/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver;

import com.dsoft.powerpro.monitoring.mserver.reqeust.RequestStatusPacket;
import com.dsoft.powerpro.monitorserver.snmp.SnmpPoolManager;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import org.picocontainer.annotations.Inject;

public class DeviceMonitoring {
    private static final Logger logger = Logger.getLogger(DeviceMonitoring.class.getName());
    @Inject
    private SnmpPoolManager snmpPoolManager;
    private static DeviceMonitoring instance;

    public static DeviceMonitoring getInstance() {
        return instance;
    }

    public DeviceMonitoring() {
        instance = this;
    }

    public void changeDeviceMonitorThreadState(Integer deviceId, boolean started) {
        if (started) {
            this.snmpPoolManager.addDeviceMonitorTask(deviceId);
        } else {
            this.snmpPoolManager.removeDeviceMonitorTask(deviceId);
        }
    }

    public void changeSnmpThreadState(Serializable packet) {
        RequestStatusPacket statusPacket = (RequestStatusPacket)packet;
        if (statusPacket.getRequestPacketType() == 1) {
            this.snmpPoolManager.updateThreadExpirng(statusPacket);
            return;
        }
        this.snmpPoolManager.addSNMPMonitorTask(statusPacket);
    }

    @PreDestroy
    public void stop() throws Exception {
        logger.info("Monitoring service stoping...");
    }
}

