/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver;

import com.dsoft.powerpro.agent.persistance.AutoincrementPK;
import com.dsoft.powerpro.agent.persistance.FilePersistance;
import com.dsoft.powerpro.agent.persistance.FinderException;
import com.dsoft.powerpro.agent.persistance.FinderExpression;
import com.dsoft.powerpro.agent.persistance.PersistanceException;
import com.dsoft.powerpro.internet.client.InternetUtils;
import com.dsoft.powerpro.monitoring.mserver.reqeust.RequestStatusPacket;
import com.dsoft.powerpro.monitoring.mserver.reqeust.ServerProcessPingPacket;
import com.dsoft.powerpro.monitorserver.dto.DeviceDTO;
import com.dsoft.powerpro.monitorserver.dto.DeviceOidParametersDTO;
import com.dsoft.powerpro.monitorserver.dto.DeviceOidParametersPK;
import com.dsoft.powerpro.monitorserver.dto.DevicePingResponseDTO;
import com.dsoft.powerpro.monitorserver.dto.SnmpConfigsDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import org.picocontainer.annotations.Inject;

public class MonitoringManager {
    private static final Logger logger = Logger.getLogger(MonitoringManager.class.getName());
    private FilePersistance persistance;
    private static MonitoringManager instance;

    public static MonitoringManager getInstance() {
        return instance;
    }

    public MonitoringManager() {
        instance = this;
    }

    public void addDevice(DeviceDTO dto) throws Exception {
        try {
            this.persistance.findByPrimaryKey(DeviceDTO.class, dto.getId());
            this.persistance.updateEntity(dto);
        }
        catch (FinderException fe) {
            this.persistance.addEntity(dto);
        }
    }

    public void addDevicePingResponse(Integer id, Integer deviceId, long startTime, long endTime) throws Exception {
        DevicePingResponseDTO devPingResponse = null;
        if (id == null) {
            id = (Integer)this.persistance.nextPrimaryKey(DevicePingResponseDTO.class);
            devPingResponse = new DevicePingResponseDTO();
            devPingResponse.setId(id);
        } else {
            devPingResponse = this.persistance.findByPrimaryKey(DevicePingResponseDTO.class, id);
        }
        devPingResponse.setStartTime(startTime);
        devPingResponse.setEndTime(endTime);
        devPingResponse.setDeviceId(deviceId);
        this.persistance.updateEntity(devPingResponse);
    }

    public SnmpConfigsDTO addSnmpConfig(SnmpConfigsDTO confDto) throws Exception {
        try {
            this.persistance.findByPrimaryKey(SnmpConfigsDTO.class, confDto.getId());
            this.persistance.updateEntity(confDto);
        }
        catch (FinderException fe) {
            this.persistance.addEntity(confDto);
        }
        return confDto;
    }

    private boolean checkDeviceRowValidity(long currentTime, DeviceDTO device) {
        long validFrom = -1L;
        long validTo = Long.MAX_VALUE;
        if (device.getRowIdentifier() != null) {
            if (device.getValidFrom() != null) {
                validFrom = device.getValidFrom();
            }
            if (device.getValidTo() != null) {
                validTo = device.getValidTo();
            }
            if (currentTime < validFrom || currentTime > validTo) {
                return false;
            }
        }
        return true;
    }

    private Collection<DeviceDTO> findDevicesByIP(final long ipAddress) throws FinderException {
        Collection<DeviceDTO> devices = this.persistance.findEntities(DeviceDTO.class, new FinderExpression<DeviceDTO>(){

            @Override
            public boolean acceptEntity(DeviceDTO entity) {
                return entity.getIpAddress() != null && entity.getIpAddress() == ipAddress;
            }
        });
        return devices;
    }

    private Collection<DeviceDTO> findDevicesByMac(final String macAddress) throws FinderException {
        Collection<DeviceDTO> devices = this.persistance.findEntities(DeviceDTO.class, new FinderExpression<DeviceDTO>(){

            @Override
            public boolean acceptEntity(DeviceDTO entity) {
                return entity.getMac() != null && entity.getMac().equals(macAddress);
            }
        });
        return devices;
    }

    public DeviceDTO getDevice(Integer deviceId) throws FinderException {
        return this.persistance.findByPrimaryKey(DeviceDTO.class, deviceId);
    }

    public Integer getDeviceId(long ipAddress) throws Exception {
        Collection<DeviceDTO> devices = this.findDevicesByIP(ipAddress);
        for (DeviceDTO device : devices) {
            if (!this.checkDeviceRowValidity(System.currentTimeMillis(), device)) continue;
            return device.getId();
        }
        return null;
    }

    public Integer getDeviceId(String mac) throws Exception {
        Collection<DeviceDTO> devices = this.findDevicesByMac(mac);
        for (DeviceDTO device : devices) {
            if (!this.checkDeviceRowValidity(System.currentTimeMillis(), device)) continue;
            return device.getId();
        }
        return null;
    }

    public Long getDeviceIp(Integer id) throws Exception {
        try {
            Long ip = this.persistance.findByPrimaryKey(DeviceDTO.class, id).getIpAddress();
            if (ip != null && ip != 0L) {
                return ip;
            }
        }
        catch (FinderException finderException) {
            // empty catch block
        }
        return null;
    }

    public DevicePingResponseDTO getDeviceLastPing(Integer deviceId) throws Exception {
        List<DevicePingResponseDTO> devicePingStates = this.getDevicePingResponses(deviceId);
        if (devicePingStates.isEmpty()) {
            return null;
        }
        Collections.sort(devicePingStates, new Comparator<DevicePingResponseDTO>(){

            @Override
            public int compare(DevicePingResponseDTO o1, DevicePingResponseDTO o2) {
                return new Long(o1.getEndTime()).compareTo(o2.getEndTime());
            }
        });
        return devicePingStates.get(devicePingStates.size() - 1);
    }

    public List<DevicePingResponseDTO> getDevicePingResponses(final Integer deviceId) throws Exception {
        return new ArrayList<DevicePingResponseDTO>(this.persistance.findEntities(DevicePingResponseDTO.class, new FinderExpression<DevicePingResponseDTO>(){

            @Override
            public boolean acceptEntity(DevicePingResponseDTO entity) {
                return entity.getDeviceId().equals(deviceId);
            }
        }));
    }

    public String getDeviceQueueName(Integer deviceId) throws Exception {
        return this.getDevice(deviceId).getDeviceType();
    }

    public ArrayList<DeviceDTO> getDevices() throws Exception {
        return new ArrayList<DeviceDTO>(this.persistance.findAll(DeviceDTO.class));
    }

    public DeviceDTO getDevicesByMacAddress(String macAddress) throws Exception {
        Collection<DeviceDTO> devices = this.findDevicesByMac(macAddress);
        long currentTime = System.currentTimeMillis();
        DeviceDTO dev = null;
        for (DeviceDTO devDto : devices) {
            if (!this.checkDeviceRowValidity(currentTime, devDto)) continue;
            dev = devDto;
        }
        return dev;
    }

    public List<DeviceDTO> getDevicesByType(final String deviceTypeName) throws Exception {
        return new ArrayList<DeviceDTO>(this.persistance.findEntities(DeviceDTO.class, new FinderExpression<DeviceDTO>(){

            @Override
            public boolean acceptEntity(DeviceDTO entity) {
                return entity.isMonitorDevSpecParams() && entity.getDeviceType().equals(deviceTypeName);
            }
        }));
    }

    public List<DeviceDTO> getDevicesForMonitoring() throws Exception {
        return new ArrayList<DeviceDTO>(this.persistance.findEntities(DeviceDTO.class, new FinderExpression<DeviceDTO>(){

            @Override
            public boolean acceptEntity(DeviceDTO entity) {
                return entity.isProcessMonitoring();
            }
        }));
    }

    public SnmpConfigsDTO getDeviceSNMPConfig(Integer deviceId) throws Exception {
        if (deviceId == null) {
            return null;
        }
        SnmpConfigsDTO snmpConfig = null;
        try {
            DeviceDTO devDto = this.persistance.findByPrimaryKey(DeviceDTO.class, deviceId);
            if (devDto.getConfigId() != null) {
                snmpConfig = this.persistance.findByPrimaryKey(SnmpConfigsDTO.class, devDto.getConfigId());
            }
            return snmpConfig;
        }
        catch (FinderException ex) {
            System.out.println(deviceId);
            throw ex;
        }
    }

    public List<DeviceOidParametersDTO> getMonitoredDeviceOIDs(final Integer deviceId) throws Exception {
        return new ArrayList<DeviceOidParametersDTO>(this.persistance.findEntities(DeviceOidParametersDTO.class, new FinderExpression<DeviceOidParametersDTO>(){

            @Override
            public boolean acceptEntity(DeviceOidParametersDTO entity) {
                return entity.getDeviceid().equals(deviceId) && entity.isProcessMonitoring();
            }
        }));
    }

    public List<DeviceOidParametersDTO> getOIDsForMonitoring() throws Exception {
        return new ArrayList<DeviceOidParametersDTO>(this.persistance.findEntities(DeviceOidParametersDTO.class, new FinderExpression<DeviceOidParametersDTO>(){

            @Override
            public boolean acceptEntity(DeviceOidParametersDTO entity) {
                return entity.isProcessMonitoring();
            }
        }));
    }

    public void incrementMonitorIteration(Integer deviceId, Integer iteration) throws PersistanceException {
        DeviceDTO deviceDto;
        try {
            deviceDto = this.persistance.findByPrimaryKey(DeviceDTO.class, deviceId);
        }
        catch (FinderException ex) {
            return;
        }
        deviceDto.setMonitorIteration(iteration);
        this.persistance.updateEntity(deviceDto);
    }

    public void removeDevice(final Integer deviceId) throws PersistanceException {
        Collection<DeviceOidParametersDTO> oidParams = this.persistance.findEntities(DeviceOidParametersDTO.class, new FinderExpression<DeviceOidParametersDTO>(){

            @Override
            public boolean acceptEntity(DeviceOidParametersDTO entity) {
                return entity.getDeviceid().equals(deviceId);
            }
        });
        for (DeviceOidParametersDTO devOidDto : oidParams) {
            this.persistance.removeEntity(devOidDto);
        }
        try {
            DeviceDTO devDto = this.persistance.findByPrimaryKey(DeviceDTO.class, deviceId);
            this.persistance.removeEntity(devDto);
        }
        catch (FinderException finderException) {
            // empty catch block
        }
    }

    public void setDevicePingStatus(ServerProcessPingPacket processPacket) throws Exception {
        DeviceDTO deviceDto = null;
        try {
            deviceDto = this.persistance.findByPrimaryKey(DeviceDTO.class, processPacket.getDeviceId());
        }
        catch (FinderException fe) {
            deviceDto = new DeviceDTO();
            deviceDto.setId(processPacket.getDeviceId());
            deviceDto.setIpAddress(InternetUtils.ipStringToLong2((String)processPacket.getIpAddress()));
        }
        deviceDto.setProcessMonitoring(processPacket.isProcessPingDevice());
        deviceDto.setPingType(new Integer(processPacket.getPingType()));
        deviceDto.setMonitorDevSpecParams(processPacket.isMonitorDevSpecParams());
        deviceDto.setMonitorParamsTimeout(processPacket.getMonitorParamsTimeout());
        deviceDto.setMonitoringTimeout(processPacket.getProcessPingDeviceTimeout());
        this.persistance.updateEntity(deviceDto);
    }

    public DeviceOidParametersDTO setDeviceStatus(RequestStatusPacket packet) throws Exception {
        String oid;
        block7: {
            oid = null;
            try {
                if (packet.getOidParameters() != null) break block7;
                return null;
            }
            catch (FinderException fex) {
                DeviceOidParametersDTO dto = new DeviceOidParametersDTO();
                dto.setDeviceid(packet.getDeviceId());
                dto.setOid(oid);
                if (!packet.isDeviceMonitoringActive()) {
                    dto.setProcessMonitoring(false);
                    return dto;
                }
                dto.setTimeout(packet.getTimeout());
                dto.setProcessMonitoring(true);
                this.persistance.addEntity(dto);
                return dto;
            }
        }
        Iterator it = packet.getOidParameters().iterator();
        if (!it.hasNext()) {
            return null;
        }
        oid = (String)it.next();
        DeviceOidParametersDTO oidParam = this.persistance.findByPrimaryKey(DeviceOidParametersDTO.class, new DeviceOidParametersPK(packet.getDeviceId(), oid));
        if (!packet.isDeviceMonitoringActive()) {
            this.persistance.removeEntity(oidParam);
            oidParam.setDeviceid(packet.getDeviceId());
            oidParam.setProcessMonitoring(false);
            oidParam.setOid(oid);
            return oidParam;
        }
        oidParam.setTimeout(packet.getTimeout());
        oidParam.setProcessMonitoring(true);
        this.persistance.updateEntity(oidParam);
        return oidParam;
    }

    @Inject
    public void setPersistance(FilePersistance persistance) {
        this.persistance = persistance;
    }

    @PostConstruct
    public void start() {
        logger.fine("Initializing monitoring manager");
        try {
            this.persistance.registerTable("device", DeviceDTO.class);
            this.persistance.registerTable("snmp_config", SnmpConfigsDTO.class);
            this.persistance.registerTable("deviceOidParam", DeviceOidParametersDTO.class);
            this.persistance.registerTable("devicePingState", DevicePingResponseDTO.class, new IntegerAutoInc());
        }
        catch (PersistanceException ex) {
            logger.log(Level.SEVERE, "Unable to initialize persistance mapping", ex);
        }
    }

    class IntegerAutoInc
    implements AutoincrementPK {
        int currentInt = 0;

        IntegerAutoInc() {
        }

        @Override
        public void initializePKGenerator(Object[] existingKeys) {
            if (existingKeys != null) {
                Arrays.sort(existingKeys);
                this.currentInt = (Integer)existingKeys[existingKeys.length - 1] + 1;
            }
        }

        @Override
        public Object nextPK() {
            return this.currentInt++;
        }
    }
}

