/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver;

import com.dsoft.powerpro.agent.messaging.MessageDistributor;
import com.dsoft.powerpro.agent.messaging.MessageListener;
import com.dsoft.powerpro.internet.client.InternetUtils;
import com.dsoft.powerpro.internet.client.exception.InvalidIPFormatException;
import com.dsoft.powerpro.internet.mserver.InfoPacket;
import com.dsoft.powerpro.internet.mserver.queue.MessageQueue;
import com.dsoft.powerpro.monitoring.mserver.reqeust.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitoring.mserver.reqeust.DeviceRequestPacket;
import com.dsoft.powerpro.monitoring.mserver.reqeust.RegisterDevicePacket;
import com.dsoft.powerpro.monitoring.mserver.reqeust.RequestInterfaceStatusPacket;
import com.dsoft.powerpro.monitoring.mserver.reqeust.RequestPacket;
import com.dsoft.powerpro.monitoring.mserver.reqeust.RequestStatusPacket;
import com.dsoft.powerpro.monitoring.mserver.reqeust.ServerPingPacket;
import com.dsoft.powerpro.monitoring.mserver.reqeust.ServerProcessPingPacket;
import com.dsoft.powerpro.monitoring.mserver.reqeust.ServerSNMPConfigPacket;
import com.dsoft.powerpro.monitoring.mserver.reqeust.UnregisterDevicePacket;
import com.dsoft.powerpro.monitoring.mserver.response.PingStatusPacket;
import com.dsoft.powerpro.monitoring.mserver.response.ResponseStatusPacket;
import com.dsoft.powerpro.monitorserver.DeviceMonitoring;
import com.dsoft.powerpro.monitorserver.MonitoringManager;
import com.dsoft.powerpro.monitorserver.dto.DeviceDTO;
import com.dsoft.powerpro.monitorserver.dto.DeviceOidParametersDTO;
import com.dsoft.powerpro.monitorserver.dto.SnmpConfigsDTO;
import com.dsoft.powerpro.monitorserver.util.QueueListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.picocontainer.annotations.Inject;

public class MonitoringMessageProcessor
implements Runnable {
    private final String defaultQueueName = "SNMPNetworkDeviceDto";
    private static MonitoringMessageProcessor instance;
    private static final Logger logger;
    private Thread writeThread;
    private ArrayList<Packet> messageList = new ArrayList();
    private MessageQueue messageQueue;
    private MonitoringManager monitoringManager;
    private DeviceMonitoring deviceMonitor;
    private HashMap<String, Thread> localQueueThreads = new HashMap();
    private HashMap<String, ArrayList<QueueListener>> listenersMap = new HashMap();
    private HashMap<String, ArrayList<InfoPacket>> infoPacketQueues = new HashMap();

    static {
        logger = Logger.getLogger(MonitoringMessageProcessor.class.getName());
    }

    public static MonitoringMessageProcessor getInstance() {
        return instance;
    }

    public MonitoringMessageProcessor() {
        instance = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(String queueName, QueueListener listener) {
        HashMap<String, ArrayList<QueueListener>> hashMap = this.listenersMap;
        synchronized (hashMap) {
            ArrayList<QueueListener> listeners = this.listenersMap.get(queueName);
            if (listeners == null) {
                listeners = new ArrayList();
                this.listenersMap.put(queueName, listeners);
                HashMap<String, Thread> hashMap2 = this.localQueueThreads;
                synchronized (hashMap2) {
                    this.localQueueThreads.put(queueName, new LocalQueueThread(queueName));
                    this.localQueueThreads.get(queueName).start();
                }
            }
            listeners.add(listener);
        }
    }

    private void changeDeviceMonitorThreadState(Integer deviceId, boolean started) {
        this.deviceMonitor.changeDeviceMonitorThreadState(deviceId, started);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        this.writeThread.interrupt();
        ArrayList<Packet> arrayList = this.messageList;
        synchronized (arrayList) {
            this.messageList.notifyAll();
        }
        this.stopLocalQueueThreads();
    }

    private void invokeChangeSnmpThreadState(RequestStatusPacket statusPacket) {
        this.deviceMonitor.changeSnmpThreadState((Serializable)statusPacket);
    }

    private void preparePacket(DeviceRequestPacket packet) throws Exception {
        if (packet.getIpAddress() == null && packet.getDeviceId() != null) {
            Long ipLong = this.monitoringManager.getDeviceIp(packet.getDeviceId());
            String ip = ipLong != null && ipLong != 0L ? InternetUtils.ipLongToString((long)ipLong) : null;
            packet.setIpAddress(ip);
        }
    }

    private void processDeviceMonitoringStatusPacket(RequestStatusPacket statusPacket) throws Exception {
        DeviceOidParametersDTO dto = null;
        if (statusPacket.getQueueId() != null) {
            this.invokeChangeSnmpThreadState(statusPacket);
        } else {
            dto = this.monitoringManager.setDeviceStatus(statusPacket);
            if (dto != null) {
                statusPacket.setTimeout(dto.getTimeout());
                statusPacket.setDeviceMonitoringActive(dto.isProcessMonitoring());
                this.invokeChangeSnmpThreadState(statusPacket);
                ResponseStatusPacket response = new ResponseStatusPacket(statusPacket);
                response.setDeviceId(statusPacket.getDeviceId());
                this.sendInfoPacket((Serializable)response, true);
            }
        }
    }

    private void processDeviceOIDParmeterPacket(DeviceOIDParameterPacket oidParamPacket) throws Exception {
        String queueName = null;
        if (oidParamPacket.getIpAddress() == null) {
            if (oidParamPacket.getDeviceId() != null) {
                queueName = this.monitoringManager.getDeviceQueueName(oidParamPacket.getDeviceId());
                SnmpConfigsDTO dto = this.monitoringManager.getDeviceSNMPConfig(oidParamPacket.getDeviceId());
                Long ipLong = this.monitoringManager.getDeviceIp(oidParamPacket.getDeviceId());
                if (ipLong != null) {
                    String ip = InternetUtils.ipLongToString((long)ipLong);
                    oidParamPacket.setReadCommunity(dto.getReadcommunity());
                    oidParamPacket.setWriteCommunity(dto.getWritecommunity());
                    oidParamPacket.setRetries(Integer.valueOf(dto.getRetries() != null ? dto.getRetries() : 0));
                    oidParamPacket.setTimeout(Long.valueOf(dto.getTimeout()));
                    oidParamPacket.setIpAddress(ip);
                    oidParamPacket.setPort(Integer.valueOf(dto.getPort() != null ? dto.getPort() : 0));
                    oidParamPacket.setSnmpVersion(dto.getSnmpVersion());
                    oidParamPacket.setAuthPassword(dto.getAuthPassword());
                    oidParamPacket.setAuthProtocol(dto.getAuthProtocol());
                    oidParamPacket.setPrivPassword(dto.getPrivPassword());
                    oidParamPacket.setPrivProtocol(dto.getPrivProtocol());
                    oidParamPacket.setContextId(dto.getContextId());
                    oidParamPacket.setContextName(dto.getContextName());
                    this.sendQueuePacket((InfoPacket)oidParamPacket, queueName);
                }
            }
        } else {
            if (oidParamPacket.getDeviceId() != null) {
                queueName = this.monitoringManager.getDeviceQueueName(oidParamPacket.getDeviceId());
                SnmpConfigsDTO dto = this.monitoringManager.getDeviceSNMPConfig(oidParamPacket.getDeviceId());
                oidParamPacket.setReadCommunity(dto.getReadcommunity());
                oidParamPacket.setWriteCommunity(dto.getWritecommunity());
                oidParamPacket.setRetries(Integer.valueOf(dto.getRetries()));
                oidParamPacket.setTimeout(Long.valueOf(dto.getTimeout()));
                oidParamPacket.setPort(Integer.valueOf(dto.getPort()));
                oidParamPacket.setSnmpVersion(dto.getSnmpVersion());
                oidParamPacket.setAuthPassword(dto.getAuthPassword());
                oidParamPacket.setAuthProtocol(dto.getAuthProtocol());
                oidParamPacket.setPrivPassword(dto.getPrivPassword());
                oidParamPacket.setPrivProtocol(dto.getPrivProtocol());
                oidParamPacket.setContextId(dto.getContextId());
                oidParamPacket.setContextName(dto.getContextName());
                oidParamPacket.setSecurityUserName(dto.getSecurityUserName());
            }
            this.sendQueuePacket((InfoPacket)oidParamPacket, queueName);
        }
    }

    private void processRegisterDevicePacket(RegisterDevicePacket devicePacket) throws Exception {
        String queueName = null;
        ServerSNMPConfigPacket config = devicePacket.getSnmpConfig();
        if (config != null && config.getId() != null) {
            SnmpConfigsDTO confDto = new SnmpConfigsDTO();
            confDto.setId(config.getId());
            confDto.setPort(config.getPort());
            confDto.setReadcommunity(config.getReadCommunity());
            confDto.setWritecommunity(config.getWriteCommunity());
            confDto.setRetries(new Integer(config.getRetries()));
            confDto.setTimeout(config.getTimeout());
            confDto.setSnmpVersion(config.getSnmpVersion());
            confDto.setAuthPassword(config.getAuthPassword());
            confDto.setAuthProtocol(config.getAuthProtocol());
            confDto.setPrivPassword(config.getPrivPassword());
            confDto.setPrivProtocol(config.getPrivProtocol());
            confDto.setContextId(config.getContextId());
            confDto.setContextName(config.getContextName());
            confDto.setSecurityUserName(config.getSecurityUserName());
            this.monitoringManager.addSnmpConfig(confDto);
        }
        DeviceDTO devDto = new DeviceDTO();
        devDto.setId(devicePacket.getDeviceId());
        devDto.setConfigId(devicePacket.getConfigId());
        devDto.setIpAddress(new Long(InternetUtils.ipStringToLong((String)devicePacket.getIpAddress())));
        devDto.setDeviceType(devicePacket.getDeviceTypeName());
        devDto.setServiceId(devicePacket.getServiceId());
        devDto.setMac(devicePacket.getMac());
        devDto.setRowIdentifier(devicePacket.getRowIdentifier());
        devDto.setValidFrom(devicePacket.getValidFrom());
        devDto.setValidTo(devicePacket.getValidTo());
        this.monitoringManager.addDevice(devDto);
        queueName = this.monitoringManager.getDeviceQueueName(devDto.getId());
        if (queueName != null) {
            this.sendQueuePacket((InfoPacket)devicePacket, queueName);
        }
    }

    private void processRequestInterfaceStatusPacket(RequestInterfaceStatusPacket packet) throws Exception {
        this.invokeChangeSnmpThreadState((RequestStatusPacket)packet);
    }

    private void processServerPingPacket(ServerPingPacket pingPacket) throws Exception {
        String queueName = null;
        if (pingPacket.getIpAddress() == null) {
            if (pingPacket.getDeviceId() != null) {
                queueName = this.monitoringManager.getDeviceQueueName(pingPacket.getDeviceId());
            }
        } else {
            if (pingPacket.getDeviceId() == null) {
                try {
                    pingPacket.setDeviceId(this.monitoringManager.getDeviceId(InternetUtils.ipStringToLong((String)pingPacket.getIpAddress())));
                }
                catch (InvalidIPFormatException invalidIPFormatException) {
                    // empty catch block
                }
            }
            if (pingPacket.getDeviceId() != null) {
                queueName = this.monitoringManager.getDeviceQueueName(pingPacket.getDeviceId());
            }
        }
        if (queueName == null) {
            queueName = "SNMPNetworkDeviceDto";
        }
        this.sendQueuePacket((InfoPacket)pingPacket, queueName);
    }

    private void processServerProcessPingPacket(ServerProcessPingPacket processPacket) throws Exception {
        this.monitoringManager.setDevicePingStatus(processPacket);
        this.changeDeviceMonitorThreadState(processPacket.getDeviceId(), processPacket.isProcessPingDevice());
        String queueName = this.monitoringManager.getDeviceQueueName(processPacket.getDeviceId());
        if (queueName != null) {
            this.sendQueuePacket((InfoPacket)processPacket, queueName);
        }
        PingStatusPacket monPacket = new PingStatusPacket();
        monPacket.setDeviceId(processPacket.getDeviceId());
        monPacket.setProcessPingDevice(processPacket.isProcessPingDevice());
        monPacket.setPingType(processPacket.getPingType());
        monPacket.setMonitorDevSpecParams(processPacket.isMonitorDevSpecParams());
        monPacket.setMonitorParamsTimeout(processPacket.getMonitorParamsTimeout());
        monPacket.setProcessPingDeviceTimeout(processPacket.getProcessPingDeviceTimeout());
        this.sendInfoPacket((Serializable)monPacket, true);
    }

    private void processServerSNMPConfigPacket(ServerSNMPConfigPacket configPacket) throws Exception {
        SnmpConfigsDTO confDto = new SnmpConfigsDTO();
        confDto.setId(configPacket.getId());
        confDto.setPort(new Integer(configPacket.getPort()));
        confDto.setReadcommunity(configPacket.getReadCommunity());
        confDto.setWritecommunity(configPacket.getWriteCommunity());
        confDto.setRetries(new Integer(configPacket.getRetries()));
        confDto.setTimeout(configPacket.getTimeout());
        confDto.setSnmpVersion(configPacket.getSnmpVersion());
        confDto.setAuthPassword(configPacket.getAuthPassword());
        confDto.setAuthProtocol(configPacket.getAuthProtocol());
        confDto.setPrivPassword(configPacket.getPrivPassword());
        confDto.setPrivProtocol(configPacket.getPrivProtocol());
        confDto.setContextId(configPacket.getContextId());
        confDto.setContextName(configPacket.getContextName());
        confDto.setSecurityUserName(configPacket.getSecurityUserName());
        this.monitoringManager.addSnmpConfig(confDto);
    }

    private void processUnregisterDevicePacket(UnregisterDevicePacket devicePacket) throws Exception {
        String queueName = null;
        List<DeviceOidParametersDTO> list = this.monitoringManager.getMonitoredDeviceOIDs(devicePacket.getDeviceId());
        RequestStatusPacket statusPacket = null;
        for (DeviceOidParametersDTO dto : list) {
            TreeSet<String> oid = new TreeSet<String>();
            oid.add(dto.getOid());
            statusPacket = new RequestStatusPacket();
            statusPacket.setDeviceId(dto.getDeviceid());
            statusPacket.setTimeout(dto.getTimeout());
            statusPacket.setDeviceMonitoringActive(false);
            statusPacket.setOidParameters(oid);
            this.invokeChangeSnmpThreadState(statusPacket);
        }
        queueName = this.monitoringManager.getDeviceQueueName(devicePacket.getDeviceId());
        if (queueName != null) {
            this.sendQueuePacket((InfoPacket)devicePacket, queueName);
        }
        this.monitoringManager.removeDevice(devicePacket.getDeviceId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ArrayList<Serializable> lowPrioPackets = new ArrayList<Serializable>();
            while (!Thread.currentThread().isInterrupted()) {
                if (this.messageList.isEmpty()) {
                    ArrayList<Packet> arrayList = this.messageList;
                    synchronized (arrayList) {
                        try {
                            this.messageList.wait(1000L);
                        }
                        catch (InterruptedException ex) {
                            return;
                        }
                    }
                }
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                if (this.messageList.isEmpty() && lowPrioPackets.isEmpty()) continue;
                if (this.messageList.isEmpty() && !lowPrioPackets.isEmpty()) {
                    this.writeDataToQueue(lowPrioPackets, false);
                    lowPrioPackets.clear();
                }
                long totalTimeToSend = 0L;
                int counter = 0;
                while (!this.messageList.isEmpty() && !Thread.currentThread().isInterrupted()) {
                    long start = System.currentTimeMillis();
                    ArrayList<Serializable> highPrioPackets = new ArrayList<Serializable>();
                    ArrayList<Packet> arrayList = this.messageList;
                    synchronized (arrayList) {
                        for (Packet packet : this.messageList) {
                            if (packet.highPriority) {
                                highPrioPackets.add(packet.infoPacket);
                                continue;
                            }
                            lowPrioPackets.add(packet.infoPacket);
                        }
                        this.messageList.clear();
                    }
                    if (!highPrioPackets.isEmpty()) {
                        if (highPrioPackets.size() == 1) {
                            this.sendSinglePacket((Serializable)highPrioPackets.get(0), true);
                        } else {
                            this.writeDataToQueue(highPrioPackets, true);
                        }
                        counter += highPrioPackets.size();
                    }
                    if (!lowPrioPackets.isEmpty() && lowPrioPackets.size() > 20) {
                        if (lowPrioPackets.size() == 1) {
                            this.sendSinglePacket((Serializable)lowPrioPackets.get(0), false);
                        } else {
                            this.writeDataToQueue(lowPrioPackets, false);
                        }
                        counter += lowPrioPackets.size();
                        lowPrioPackets.clear();
                    }
                    totalTimeToSend += System.currentTimeMillis() - start;
                    if (counter <= 100) continue;
                    logger.log(Level.FINE, String.format("Average time to send message %1$dms for %2$d messages", totalTimeToSend / (long)counter, counter));
                }
                if (counter <= 0) continue;
                logger.log(Level.FINE, String.format("Average time to send message %1$dms for %2$d messages", totalTimeToSend / (long)counter, counter));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendInfoPacket(Serializable infoPacket, boolean highPriority) {
        Packet packet = new Packet();
        packet.infoPacket = infoPacket;
        packet.highPriority = highPriority;
        ArrayList<Packet> arrayList = this.messageList;
        synchronized (arrayList) {
            if (highPriority) {
                this.messageList.add(0, packet);
            } else {
                this.messageList.add(packet);
            }
            this.messageList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQueuePacket(InfoPacket infoPacket, String queueName) {
        HashMap<String, ArrayList<InfoPacket>> hashMap = this.infoPacketQueues;
        synchronized (hashMap) {
            ArrayList<Object> packetQueue = this.infoPacketQueues.get(queueName);
            if (packetQueue == null) {
                if (this.localQueueThreads.containsKey(queueName)) {
                    packetQueue = new ArrayList();
                    this.infoPacketQueues.put(queueName, packetQueue);
                } else {
                    return;
                }
            }
            packetQueue.add(infoPacket);
            this.infoPacketQueues.notifyAll();
        }
    }

    private void sendSinglePacket(Serializable packet, boolean highPriority) throws Exception {
        try {
            this.writeDataToQueue(packet, highPriority);
        }
        catch (Exception ex) {
            this.sendInfoPacket(packet, highPriority);
            throw ex;
        }
    }

    @Inject
    public void setDeviceMonitor(DeviceMonitoring deviceMonitor) {
        this.deviceMonitor = deviceMonitor;
    }

    @Inject
    public void setMessageDistributor(MessageDistributor distributor) {
        distributor.addMessageListener(RequestPacket.class, new MessageProcessThread());
    }

    @Inject
    public void setMessageQueue(MessageQueue messageQueue) {
        this.messageQueue = messageQueue;
    }

    @Inject
    public void setMonitoringManager(MonitoringManager monitoringManager) {
        this.monitoringManager = monitoringManager;
    }

    @Inject
    public void setThreadGroup(ThreadGroup threadGroup) {
        this.writeThread = new Thread(threadGroup, this);
    }

    @PostConstruct
    public void start() {
        this.writeThread.start();
    }

    @PreDestroy
    public void stop() {
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopLocalQueueThreads() {
        HashMap<String, Thread> hashMap = this.localQueueThreads;
        synchronized (hashMap) {
            for (Thread thread : this.localQueueThreads.values()) {
                thread.interrupt();
            }
        }
    }

    private void writeDataToQueue(Object infoPacket, boolean highPriority) throws Exception {
        this.messageQueue.postMessage(infoPacket, highPriority ? new Integer(1) : new Integer(0), 86400000L, new Integer(0), true);
    }

    class LocalQueueThread
    extends Thread {
        private String queueName;

        LocalQueueThread(String queueName) {
            super("Local queue thread for " + queueName);
            this.queueName = queueName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                ArrayList queueCopy = new ArrayList();
                HashMap hashMap = MonitoringMessageProcessor.this.infoPacketQueues;
                synchronized (hashMap) {
                    ArrayList packetQueue;
                    while ((packetQueue = (ArrayList)MonitoringMessageProcessor.this.infoPacketQueues.get(this.queueName)) == null || packetQueue.isEmpty()) {
                        try {
                            MonitoringMessageProcessor.this.infoPacketQueues.wait();
                        }
                        catch (InterruptedException ex) {
                            return;
                        }
                    }
                    queueCopy.addAll(packetQueue);
                    packetQueue.clear();
                }
                hashMap = MonitoringMessageProcessor.this.listenersMap;
                synchronized (hashMap) {
                    for (InfoPacket packet : queueCopy) {
                        for (QueueListener listener : (ArrayList)MonitoringMessageProcessor.this.listenersMap.get(this.queueName)) {
                            listener.processPacket(packet);
                        }
                    }
                }
            }
        }
    }

    class MessageProcessThread
    implements MessageListener {
        MessageProcessThread() {
        }

        @Override
        public void beginProcessing() {
        }

        @Override
        public void endProcessing() {
        }

        @Override
        public void processMessage(Object message) {
            if (message instanceof RequestPacket) {
                RequestPacket packet = (RequestPacket)message;
                this.processPacket(packet);
            }
        }

        private void processPacket(RequestPacket packet) {
            try {
                if (packet instanceof DeviceRequestPacket) {
                    MonitoringMessageProcessor.this.preparePacket((DeviceRequestPacket)packet);
                }
                if (packet instanceof ServerPingPacket) {
                    MonitoringMessageProcessor.this.processServerPingPacket((ServerPingPacket)packet);
                }
                if (packet instanceof DeviceOIDParameterPacket) {
                    MonitoringMessageProcessor.this.processDeviceOIDParmeterPacket((DeviceOIDParameterPacket)packet);
                }
                if (packet instanceof RequestInterfaceStatusPacket) {
                    MonitoringMessageProcessor.this.processRequestInterfaceStatusPacket((RequestInterfaceStatusPacket)packet);
                } else if (packet instanceof RequestStatusPacket) {
                    MonitoringMessageProcessor.this.processDeviceMonitoringStatusPacket((RequestStatusPacket)packet);
                }
                if (packet instanceof ServerProcessPingPacket) {
                    MonitoringMessageProcessor.this.processServerProcessPingPacket((ServerProcessPingPacket)packet);
                }
                if (packet instanceof RegisterDevicePacket) {
                    MonitoringMessageProcessor.this.processRegisterDevicePacket((RegisterDevicePacket)packet);
                }
                if (packet instanceof UnregisterDevicePacket) {
                    MonitoringMessageProcessor.this.processUnregisterDevicePacket((UnregisterDevicePacket)packet);
                }
                if (packet instanceof ServerSNMPConfigPacket) {
                    MonitoringMessageProcessor.this.processServerSNMPConfigPacket((ServerSNMPConfigPacket)packet);
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    class Packet {
        Serializable infoPacket;
        boolean highPriority;

        Packet() {
        }
    }
}

