/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver;

import com.dsoft.powerpro.agent.BaseServerProperties;
import com.dsoft.powerpro.agent.messaging.MessageDistributor;
import com.dsoft.powerpro.agent.messaging.MessageDistributorImpl;
import com.dsoft.powerpro.agent.messaging.MessagingAgent;
import com.dsoft.powerpro.agent.messaging.MonitoringAgent;
import com.dsoft.powerpro.agent.persistance.FilePersistance;
import com.dsoft.powerpro.internet.mserver.queue.MessageQueue;
import com.dsoft.powerpro.monitorserver.DeviceMonitoring;
import com.dsoft.powerpro.monitorserver.MonitoringManager;
import com.dsoft.powerpro.monitorserver.MonitoringMessageProcessor;
import com.dsoft.powerpro.monitorserver.ServerProperties;
import com.dsoft.powerpro.monitorserver.devices.CMTSDeviceMonitoring;
import com.dsoft.powerpro.monitorserver.devices.IPDeviceMonitoring;
import com.dsoft.powerpro.monitorserver.devices.MTADeviceMonitoring;
import com.dsoft.powerpro.monitorserver.devices.SNMPDeviceMonitoring;
import com.dsoft.powerpro.monitorserver.icmp.PingPoolManager;
import com.dsoft.powerpro.monitorserver.messaging.GatewayMessageQueue;
import com.dsoft.powerpro.monitorserver.snmp.SNMPTrapServer;
import com.dsoft.powerpro.monitorserver.snmp.SnmpPoolManager;
import com.dsoft.powerpro.monitorserver.syslog.ProcessPacketThread;
import com.dsoft.powerpro.monitorserver.util.LinuxRuntime;
import com.dsoft.powerpro.syslog.server.SyslogPacketReceiver;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.Parameter;
import org.picocontainer.lifecycle.JavaEE5LifecycleStrategy;
import org.picocontainer.monitors.NullComponentMonitor;

public class SNMPMonitoringServer {
    public static void main(String[] args) {
        ConsoleHandler consoleHandler;
        FileHandler debughandler;
        try {
            debughandler = new FileHandler("monitoring.log");
            consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.ALL);
            consoleHandler.setFormatter(new SimpleFormatter(){
                private String lineSeparator = System.getProperty("line.separator");

                @Override
                public synchronized String format(LogRecord record) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(String.format("%1$td %1$tm %1$tY %1$tH:%1$tM:%1$tS", record.getMillis()));
                    if (record.getSourceMethodName() != null) {
                        sb.append(" [");
                        sb.append(record.getSourceMethodName());
                        sb.append("]");
                    }
                    sb.append(" ");
                    sb.append(this.formatMessage(record));
                    sb.append(this.lineSeparator);
                    return sb.toString();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        debughandler.setLevel(Level.WARNING);
        Logger.getLogger("com.dsoft").addHandler(debughandler);
        Logger.getLogger("com.dsoft").addHandler(consoleHandler);
        try {
            DefaultPicoContainer container = new DefaultPicoContainer((LifecycleStrategy)new JavaEE5LifecycleStrategy((ComponentMonitor)new NullComponentMonitor()), null);
            container.as(new Properties[]{Characteristics.CACHE}).addComponent(LinuxRuntime.class);
            container.as(new Properties[]{Characteristics.CACHE}).addComponent(String[].class, (Object)args, new Parameter[0]);
            container.as(new Properties[]{Characteristics.CACHE}).addComponent(BaseServerProperties.class, ServerProperties.class, new Parameter[0]);
            container.as(new Properties[]{Characteristics.CACHE}).addComponent(ThreadGroup.class, (Object)new ThreadGroup("SNMP Monitoring threads"), new Parameter[0]);
            container.as(new Properties[]{Characteristics.CACHE}).addComponent(MessageQueue.class, GatewayMessageQueue.class, new Parameter[0]);
            container.as(new Properties[]{Characteristics.CACHE}).addComponent(MessagingAgent.class, MonitoringAgent.class, new Parameter[0]);
            container.as(new Properties[]{Characteristics.CACHE}).addComponent(MessageDistributor.class, MessageDistributorImpl.class, new Parameter[0]);
            container.as(new Properties[]{Characteristics.CACHE}).addComponent(SyslogPacketReceiver.class);
            container.as(new Properties[]{Characteristics.CACHE}).addComponent(SNMPTrapServer.class);
            container.as(new Properties[]{Characteristics.CACHE}).addComponent(MonitoringMessageProcessor.class);
            container.as(new Properties[]{Characteristics.CACHE}).addComponent(DeviceMonitoring.class);
            container.as(new Properties[]{Characteristics.CACHE}).addComponent(PingPoolManager.class);
            container.as(new Properties[]{Characteristics.CACHE}).addComponent(MonitoringManager.class);
            container.as(new Properties[]{Characteristics.CACHE}).addComponent(SNMPDeviceMonitoring.class);
            container.as(new Properties[]{Characteristics.CACHE}).addComponent(IPDeviceMonitoring.class);
            container.as(new Properties[]{Characteristics.CACHE}).addComponent(CMTSDeviceMonitoring.class);
            container.as(new Properties[]{Characteristics.CACHE}).addComponent(MTADeviceMonitoring.class);
            container.as(new Properties[]{Characteristics.CACHE}).addComponent(ProcessPacketThread.class);
            container.as(new Properties[]{Characteristics.CACHE}).addComponent(FilePersistance.class);
            container.as(new Properties[]{Characteristics.CACHE}).addComponent(SnmpPoolManager.class);
            container.getComponent(SNMPDeviceMonitoring.class);
            container.getComponent(IPDeviceMonitoring.class);
            container.getComponent(CMTSDeviceMonitoring.class);
            container.getComponent(MTADeviceMonitoring.class);
            container.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

