/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver;

import com.dsoft.powerpro.agent.BaseServerProperties;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.picocontainer.annotations.Inject;

public class ServerProperties
extends BaseServerProperties {
    private static final ArrayList<String> SHORT_OPTIONS = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("");
            this.add("");
        }
    };
    private static final ArrayList<String> LONG_OPTIONS = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("--snmp-pool");
            this.add("--icmp-pool");
        }
    };
    private HashMap<Options, String> propertiesMap = new HashMap();
    private int snmpPool;
    private int icmpPool;

    public ServerProperties() {
        this.propertiesMap.put(Options.SNMP_POOL, "30");
        this.propertiesMap.put(Options.ICMP_POOL, "10");
    }

    @Override
    protected void displayProductName() {
        System.out.println("PowerPro Monitoring Agent Version 2.0");
        System.out.println("Copyright (c) 2009, 2011 dSoft-Bulgaria Ltd.");
    }

    @Override
    @Inject
    public void setArgs(String[] args) {
        super.setArgs(args);
    }

    @PostConstruct
    public void start() {
        this.verifyOptionValues();
    }

    @Override
    protected void displayUsageOptions() {
        super.displayUsageOptions();
        System.out.println("  --snmp-pool=count     Provides the max number of threads for SNMP thread pool. Default is 30.");
        System.out.println("  --icmp-pool=count     Provides the max number of threads for ICMP thread pool. Default is 10.");
    }

    public int getIcmpPool() {
        return this.icmpPool;
    }

    public int getSnmpPool() {
        return this.snmpPool;
    }

    @Override
    protected boolean processParam(String arg, int param) {
        if (param >= 10) {
            switch (Options.values()[param -= 10]) {
                case SNMP_POOL: 
                case ICMP_POOL: {
                    this.propertiesMap.put(Options.values()[param], arg);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return super.processParam(arg, param);
    }

    @Override
    protected int recongnizeLongOption(String paramName) {
        int result = LONG_OPTIONS.indexOf(paramName);
        if (result < 0) {
            return super.recongnizeLongOption(paramName);
        }
        return result + 10;
    }

    @Override
    protected int recongnizeShortOption(String paramName) {
        int result = SHORT_OPTIONS.indexOf(paramName);
        if (result < 0) {
            return super.recongnizeShortOption(paramName);
        }
        return result + 10;
    }

    public void setIcmpPool(int icmpPool) {
        this.icmpPool = icmpPool;
    }

    public void setSnmpPool(int snmpPool) {
        this.snmpPool = snmpPool;
    }

    @Override
    protected void verifyOptionValues() {
        super.verifyOptionValues();
        try {
            this.snmpPool = Integer.parseInt(this.propertiesMap.get((Object)Options.SNMP_POOL));
            if (this.snmpPool <= 0 || this.snmpPool >= 100) {
                this.showErrorAndExit(String.format("Invalid value for snmp thread pool size (%1$s)! Valid values are between 1 and 100.", this.propertiesMap.get((Object)Options.SNMP_POOL)));
            }
        }
        catch (NumberFormatException e) {
            this.showErrorAndExit(String.format("Invalid value for route table (%1$s)!", this.propertiesMap.get((Object)Options.SNMP_POOL)));
        }
        try {
            this.icmpPool = Integer.parseInt(this.propertiesMap.get((Object)Options.ICMP_POOL));
            if (this.icmpPool <= 0 || this.icmpPool >= 100) {
                this.showErrorAndExit(String.format("Invalid value for icmp thread pool size (%1$s)! Valid values are between 1 and 100.", this.propertiesMap.get((Object)Options.ICMP_POOL)));
            }
        }
        catch (NumberFormatException e) {
            this.showErrorAndExit(String.format("Invalid value for icmp thread pool size (%1$s)!", this.propertiesMap.get((Object)Options.ICMP_POOL)));
        }
    }

    static enum Options {
        SNMP_POOL,
        ICMP_POOL;

    }
}

