/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.devices;

import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.reqeust.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitorserver.snmp.SNMPBaseMonitor;
import com.dsoft.powerpro.monitorserver.snmp.SnmpResponseException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

public class CMMonitor
extends SNMPBaseMonitor {
    private static final Logger logger = Logger.getLogger(CMMonitor.class.getName());
    private static final String docsIfMibObjects = "1.3.6.1.2.1.10.127.1";
    private int monitorIteration = 0;
    private static final String sysUptime = "1.3.6.1.2.1.1.3";
    private static final String sysDescr = "1.3.6.1.2.1.1.1";
    private static final String[] statusIndexes = new String[]{"1.1.1.6", "1.4.1.3", "1.4.1.4", "1.4.1.5", "1.4.1.6", "1.4.1.8", "1.4.1.9", "2.2.1.3"};

    public CMMonitor() {
    }

    public CMMonitor(DeviceOIDParameterPacket packet, int monitorIteration) {
        super(packet);
        this.monitorIteration = monitorIteration;
    }

    public void readMonitoringValues(List<OIDParameterVariable> oids) {
        try {
            Snmp snmpSession = this.getSnmpSession();
            try {
                this.monitPdu.clear();
                int currentSize = oids.size();
                if (this.version == 0) {
                    this.getSNMPValuesV1(snmpSession, oids);
                } else {
                    this.getSNMPValuesV2(snmpSession, oids);
                }
                if (currentSize != oids.size() && currentSize > 0) {
                    this.readInterfaceIOStats(snmpSession, oids, new int[]{127, 6, 160});
                }
            }
            finally {
                this.closeSession(snmpSession);
            }
            if (!oids.isEmpty()) {
                this.sendOidVariablePacket(null, this.packet.getDeviceId(), oids, new Integer(this.monitorIteration));
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            ex.printStackTrace();
        }
    }

    private void getSNMPValuesV1(Snmp snmpSession, List<OIDParameterVariable> oids) throws IOException {
        PDU response;
        ResponseEvent event;
        String checkOid = docsIfMibObjects;
        this.monitPdu.setType(-95);
        this.monitPdu.getVariableBindings().clear();
        this.monitPdu.add(new VariableBinding(new OID(checkOid)));
        try {
            event = snmpSession.send(this.monitPdu, this.monitTarget, null);
        }
        catch (MessageException me) {
            logger.log(Level.SEVERE, String.format("Error while talking to ip %1$s", this.packet.getIpAddress()), me);
            throw me;
        }
        PDU pDU = response = event != null ? event.getResponse() : null;
        if (response != null) {
            Vector variables = response.getVariableBindings();
            VariableBinding numberValue = (VariableBinding)variables.get(0);
            if (!numberValue.getOid().startsWith(new OID(docsIfMibObjects))) {
                return;
            }
        } else {
            return;
        }
        List<String> requestOid = Arrays.asList(statusIndexes);
        int i = 0;
        while (i < requestOid.size()) {
            requestOid.set(i, "1.3.6.1.2.1.10.127.1." + statusIndexes[i]);
            ++i;
        }
        requestOid.add(sysDescr);
        requestOid.add(sysUptime);
        for (String currentOid : requestOid) {
            this.monitPdu.setType(-95);
            this.monitPdu.getVariableBindings().clear();
            this.monitPdu.add(new VariableBinding(new OID(currentOid)));
            try {
                event = snmpSession.send(this.monitPdu, this.monitTarget, null);
            }
            catch (MessageException me) {
                logger.log(Level.SEVERE, String.format("Erroro while talking to ip %1$s", this.packet.getIpAddress()), me);
                throw me;
            }
            PDU pDU2 = response = event != null ? event.getResponse() : null;
            if (response == null || response.getErrorStatus() != 0 || response.getType() == -88) continue;
            Vector variables = response.getVariableBindings();
            for (VariableBinding variable : variables) {
                String oid = variable.getOid().toString();
                if (!(oid = oid.substring(0, oid.lastIndexOf("."))).equals(currentOid)) continue;
                oids.add(new OIDParameterVariable(oid, CMMonitor.variableToObject(variable.getVariable()), variable.getSyntax(), this.packet.getIpAddress()));
            }
        }
    }

    private void getSNMPValuesV2(Snmp snmpSession, List<OIDParameterVariable> oids) throws IOException {
        this.monitPdu.setType(-95);
        HashSet<String> requestOids = new HashSet<String>();
        int index = 0;
        while (index < statusIndexes.length) {
            requestOids.add("1.3.6.1.2.1.10.127.1." + statusIndexes[index++]);
        }
        requestOids.add(sysDescr);
        requestOids.add(sysUptime);
        while (!requestOids.isEmpty()) {
            PDU response;
            ResponseEvent event;
            this.monitPdu.getVariableBindings().clear();
            for (String oid : requestOids) {
                this.monitPdu.add(new VariableBinding(new OID(oid)));
            }
            try {
                event = snmpSession.send(this.monitPdu, this.monitTarget, null);
            }
            catch (MessageException me) {
                logger.log(Level.SEVERE, String.format("Error while talking to ip %1$s", this.packet.getIpAddress()), me);
                throw me;
            }
            PDU pDU = response = event != null ? event.getResponse() : null;
            if (response == null || response.getErrorStatus() != 0 || response.getType() == -88) {
                return;
            }
            Vector variables = response.getVariableBindings();
            int lastSize = requestOids.size();
            for (VariableBinding variable : variables) {
                String oid = variable.getOid().toString();
                if (!requestOids.contains(oid = oid.substring(0, oid.lastIndexOf(".")))) continue;
                requestOids.remove(oid);
                oids.add(new OIDParameterVariable(oid, CMMonitor.variableToObject(variable.getVariable()), variable.getSyntax(), this.packet.getIpAddress()));
                this.monitPdu.getVariableBindings().remove(0);
            }
            if (lastSize == requestOids.size()) break;
        }
    }

    @Override
    public boolean isDeviceLive(String address, Object monitor, Object object) throws SnmpResponseException {
        return true;
    }

    public void monitorDeviceParameters() throws UnknownHostException, InterruptedException {
    }
}

