/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.devices;

import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.reqeust.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitoring.mserver.reqeust.DeviceRequestPacket;
import com.dsoft.powerpro.monitorserver.devices.CMMonitor;
import com.dsoft.powerpro.monitorserver.snmp.PoolTaskThread;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CMMonitoringThread
extends PoolTaskThread {
    private static final Logger logger = Logger.getLogger(CMMonitoringThread.class.getName());
    private Integer monitorIteration;
    private ArrayList<OIDParameterVariable> oids;

    public static String constructThreadId(DeviceRequestPacket packet) {
        String id = "CM:" + packet.getDeviceId() + ":";
        if (packet.getQueueId() != null) {
            id = String.valueOf(id) + packet.getQueueId();
        }
        return id;
    }

    public CMMonitoringThread(DeviceOIDParameterPacket packet, Integer monitorIteration, ArrayList<OIDParameterVariable> oids) {
        super((DeviceRequestPacket)packet, 420000L);
        this.oids = oids;
        this.monitorIteration = monitorIteration;
    }

    @Override
    public void run() {
        try {
            CMMonitor cmMonitor = new CMMonitor((DeviceOIDParameterPacket)this.getPacket(), (int)this.monitorIteration);
            cmMonitor.readMonitoringValues(this.oids);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    @Override
    protected String getIdString() {
        return CMMonitoringThread.constructThreadId(this.getPacket());
    }
}

