/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.devices;

import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.reqeust.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitorserver.MonitoringManager;
import com.dsoft.powerpro.monitorserver.devices.CMMonitoringThread;
import com.dsoft.powerpro.monitorserver.dto.DeviceDTO;
import com.dsoft.powerpro.monitorserver.snmp.SNMPBaseMonitor;
import com.dsoft.powerpro.monitorserver.snmp.SnmpPoolManager;
import com.dsoft.powerpro.monitorserver.snmp.SnmpResponseException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

public class CMTSMonitor
extends SNMPBaseMonitor {
    private static final Logger logger = Logger.getLogger(CMTSMonitor.class.getName());
    private static final String docsIfSigQSignalNoise = "1.3.6.1.2.1.10.127.1.1.4.1.5";
    private static final String docsIfCmtsCmStatusEntry = "1.3.6.1.2.1.10.127.1.3.3.1";
    private static final String docsIfCmtsCmStatusSignalNoise = "1.3.6.1.2.1.10.127.1.3.3.1.13";
    private static final String activeModemsOid = "1.3.6.1.2.1.10.127.1.3.3.1.0";
    private int monitorIteration;
    private static final String[] statusIndexes = new String[]{"2", "3", "4", "5", "6", "9", "11", "12", "13", "14", "16", "17"};
    private static final int[] supportedIntfTypes = new int[]{127, 6, 160, 117, 128, 129, 205};
    private SnmpPoolManager snmpPoolManager;

    public CMTSMonitor() {
    }

    public CMTSMonitor(DeviceOIDParameterPacket packet, int monitorIteration, SnmpPoolManager snmpPoolManager) {
        super(packet);
        this.monitorIteration = monitorIteration;
        this.snmpPoolManager = snmpPoolManager;
    }

    public CMTSMonitor(int timeout, int retry) {
        super(timeout, retry);
    }

    public void readMonitoringValues() {
        Snmp snmpSession = null;
        try {
            snmpSession = this.getSnmpSession();
            try {
                this.monitPdu.clear();
                ++this.monitorIteration;
                MonitoringManager.getInstance().incrementMonitorIteration(this.packet.getDeviceId(), new Integer(this.monitorIteration));
                HashMap<Integer, Integer> activeModemsMap = this.version == 0 ? this.getParametersVersion1(snmpSession) : this.getParametersVersion2(snmpSession);
                int activeModems = 0;
                ArrayList<OIDParameterVariable> oids = new ArrayList<OIDParameterVariable>();
                if (activeModemsMap != null) {
                    for (Integer intfIndex : activeModemsMap.keySet()) {
                        int interfaceModems = activeModemsMap.get(intfIndex);
                        if (intfIndex > 0) {
                            activeModems += activeModemsMap.get(intfIndex).intValue();
                        } else {
                            intfIndex = intfIndex * -1;
                        }
                        oids.add(new OIDParameterVariable("1.3.6.1.2.1.10.127.1.3.3.1.0." + intfIndex, (Object)interfaceModems, 2, null));
                    }
                    HashMap<Integer, Integer> interfaceTypes = this.readInterfaceIOStats(snmpSession, oids, supportedIntfTypes);
                    for (Integer index : interfaceTypes.keySet()) {
                        switch (interfaceTypes.get(index)) {
                            case 128: {
                                index = index * -1;
                            }
                            case 129: 
                            case 205: {
                                if (activeModemsMap.containsKey(index)) break;
                                if (index < 0) {
                                    index = index * -1;
                                }
                                oids.add(new OIDParameterVariable("1.3.6.1.2.1.10.127.1.3.3.1.0." + index, (Object)0, 2, null));
                            }
                        }
                    }
                }
                oids.add(new OIDParameterVariable(activeModemsOid, (Object)new Integer(activeModems), 2, null));
                this.sendOidVariablePacket(null, this.packet.getDeviceId(), oids, new Integer(this.monitorIteration));
            }
            finally {
                this.closeSession(snmpSession);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            ex.printStackTrace();
        }
    }

    private HashMap<Integer, Integer> getParametersVersion1(Snmp snmpSession) throws IOException, Exception {
        String currentOid = docsIfCmtsCmStatusEntry;
        HashMap<String, ModemStatus> modemStatusMap = new HashMap<String, ModemStatus>();
        int index = 0;
        while (currentOid != null && currentOid.startsWith(docsIfCmtsCmStatusEntry) && index < statusIndexes.length) {
            Object variableValue;
            if (currentOid.equals(docsIfCmtsCmStatusEntry)) {
                currentOid = String.valueOf(currentOid) + "." + statusIndexes[index];
            }
            this.monitPdu.setType(-95);
            this.monitPdu.getVariableBindings().clear();
            this.monitPdu.add(new VariableBinding(new OID(currentOid)));
            ResponseEvent event = snmpSession.send(this.monitPdu, this.monitTarget, null);
            PDU response = event != null ? event.getResponse() : null;
            VariableBinding variable = null;
            if (response != null) {
                Vector variables = response.getVariableBindings();
                variable = (VariableBinding)variables.get(0);
                if (!variable.getOid().startsWith(new OID(docsIfCmtsCmStatusEntry))) {
                    return null;
                }
            } else {
                return null;
            }
            currentOid = variable.getOid().toString();
            String oidBase = currentOid.substring(0, currentOid.lastIndexOf("."));
            if (!(oidBase.endsWith("." + statusIndexes[index]) || ++index < statusIndexes.length && oidBase.endsWith("." + statusIndexes[index]))) {
                currentOid = docsIfCmtsCmStatusEntry;
                continue;
            }
            String modemNumber = currentOid.substring(currentOid.lastIndexOf(".") + 1, currentOid.length());
            ModemStatus modemStatus = modemStatusMap.get(modemNumber);
            if (modemStatus == null) {
                modemStatus = new ModemStatus();
                modemStatusMap.put(modemNumber, modemStatus);
            }
            if ((variableValue = CMTSMonitor.variableToObject(variable.getVariable())) == null) continue;
            switch (index) {
                case 0: {
                    modemStatus.mac = (String)variableValue;
                    break;
                }
                case 1: {
                    modemStatus.ip = (String)variableValue;
                    break;
                }
                case 2: {
                    modemStatus.downstreamIfIndex = (Integer)variableValue;
                    break;
                }
                case 3: {
                    modemStatus.upstreamIfIndex = (Integer)variableValue;
                    break;
                }
                case 5: {
                    modemStatus.status = (Integer)variableValue;
                    break;
                }
                default: {
                    String oid = currentOid.substring(0, currentOid.lastIndexOf("."));
                    modemStatus.oids.add(new OIDParameterVariable(oid, variableValue, variable.getSyntax(), this.packet.getIpAddress()));
                }
            }
        }
        return this.postprocessData(modemStatusMap);
    }

    private HashMap<Integer, Integer> postprocessData(HashMap<String, ModemStatus> modemStatusMap) throws Exception {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        for (ModemStatus modemStatus : modemStatusMap.values()) {
            Integer modemId;
            if (!new Integer(6).equals(modemStatus.status) || modemStatus.mac == null || "0.0.0.0".equals(modemStatus.ip)) continue;
            this.countActiveModem(result, modemStatus.upstreamIfIndex);
            this.countActiveModem(result, modemStatus.downstreamIfIndex * -1);
            DeviceDTO devDto = MonitoringManager.getInstance().getDevicesByMacAddress(modemStatus.mac.toUpperCase());
            Integer n = modemId = devDto != null ? devDto.getId() : null;
            if (modemId == null) continue;
            this.changeCMMonitorThreadState(modemId, modemStatus.ip, this.monitorIteration, modemStatus.oids);
        }
        return result;
    }

    public void changeCMMonitorThreadState(Integer deviceId, String ipAddress, Integer monitorIteration, ArrayList<OIDParameterVariable> oids) {
        try {
            DeviceOIDParameterPacket packet = this.snmpPoolManager.constructDeviceOIDParameterPacket(deviceId, null);
            packet.setIpAddress(ipAddress);
            CMMonitoringThread thread = new CMMonitoringThread(packet, monitorIteration, oids);
            this.snmpPoolManager.registerThread(thread, false);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private void countActiveModem(HashMap<Integer, Integer> result, Integer index) {
        Integer activeModems = result.get(index);
        if (activeModems == null) {
            result.put(index, 1);
        } else {
            result.put(index, activeModems + 1);
        }
    }

    private HashMap<Integer, Integer> getParametersVersion2(Snmp snmpSession) throws IOException, Exception {
        this.monitPdu.setType(-91);
        this.monitPdu.setMaxRepetitions(10);
        HashMap<String, VariableBinding> upstreamSnrMap = new HashMap<String, VariableBinding>();
        this.monitPdu.getVariableBindings().clear();
        this.monitPdu.add(new VariableBinding(new OID(docsIfSigQSignalNoise)));
        String statusOid = docsIfSigQSignalNoise;
        while (statusOid != null && statusOid.startsWith(docsIfSigQSignalNoise)) {
            PDU response;
            this.monitPdu.getVariableBindings().clear();
            this.monitPdu.add(new VariableBinding(new OID(statusOid)));
            ResponseEvent event = snmpSession.send(this.monitPdu, this.monitTarget, null);
            PDU pDU = response = event != null ? event.getResponse() : null;
            if (response == null) continue;
            Vector variables = response.getVariableBindings();
            for (VariableBinding variable : variables) {
                if (variable.getOid().startsWith(new OID(docsIfSigQSignalNoise))) {
                    String oid = variable.getOid().toString();
                    String upstreamIfIndex = oid.substring(oid.lastIndexOf(".") + 1);
                    upstreamSnrMap.put(upstreamIfIndex, variable);
                    statusOid = variable.getOid().toString();
                    continue;
                }
                statusOid = null;
            }
        }
        List<String> statusIndexesList = Arrays.asList(statusIndexes);
        HashMap<String, ModemStatus> modemMap = new HashMap<String, ModemStatus>();
        int index = 0;
        String currentOid = docsIfCmtsCmStatusEntry;
        block10: while (index < statusIndexes.length && currentOid.startsWith(docsIfCmtsCmStatusEntry)) {
            PDU response;
            this.monitPdu.getVariableBindings().clear();
            if (currentOid.equals(docsIfCmtsCmStatusEntry)) {
                currentOid = String.valueOf(currentOid) + "." + statusIndexes[index];
            }
            this.monitPdu.add(new VariableBinding(new OID(currentOid)));
            ResponseEvent event = snmpSession.send(this.monitPdu, this.monitTarget, null);
            PDU pDU = response = event != null ? event.getResponse() : null;
            if (response != null) {
                Vector variables = response.getVariableBindings();
                block11: for (VariableBinding variable : variables) {
                    if (variable.getOid().startsWith(new OID(docsIfCmtsCmStatusEntry))) {
                        String oid = variable.getOid().toString();
                        String oidBase = oid.substring(0, oid.lastIndexOf("."));
                        String statusIdx = oidBase.substring(oidBase.lastIndexOf(".") + 1);
                        if (!(statusIdx.equals(statusIndexes[index]) || ++index < statusIndexes.length && statusIdx.equals(statusIndexes[index]))) {
                            currentOid = docsIfCmtsCmStatusEntry;
                            continue block10;
                        }
                        String modemIndex = oid.substring(oid.lastIndexOf(".") + 1);
                        ModemStatus modemStatus = modemMap.get(modemIndex);
                        if (modemStatus == null) {
                            modemStatus = new ModemStatus();
                            modemMap.put(modemIndex, modemStatus);
                        }
                        switch (statusIndexesList.indexOf(statusIdx)) {
                            case -1: {
                                continue block11;
                            }
                            case 0: {
                                modemStatus.mac = (String)CMTSMonitor.variableToObject(variable.getVariable());
                                break;
                            }
                            case 1: {
                                modemStatus.ip = (String)CMTSMonitor.variableToObject(variable.getVariable());
                                break;
                            }
                            case 2: {
                                modemStatus.downstreamIfIndex = (Integer)CMTSMonitor.variableToObject(variable.getVariable());
                                break;
                            }
                            case 3: {
                                modemStatus.upstreamIfIndex = (Integer)CMTSMonitor.variableToObject(variable.getVariable());
                                break;
                            }
                            case 5: {
                                modemStatus.status = (Integer)CMTSMonitor.variableToObject(variable.getVariable());
                                break;
                            }
                            default: {
                                String strOid = variable.toString();
                                OIDParameterVariable oidParam = null;
                                strOid = strOid.substring(0, strOid.lastIndexOf("."));
                                if (strOid.startsWith(docsIfCmtsCmStatusSignalNoise)) {
                                    if ((Integer)CMTSMonitor.variableToObject(variable.getVariable()) == 0) {
                                        VariableBinding var = (VariableBinding)upstreamSnrMap.get("" + modemStatus.upstreamIfIndex);
                                        oidParam = new OIDParameterVariable(strOid, CMTSMonitor.variableToObject(var.getVariable()), variable.getSyntax(), this.packet.getIpAddress());
                                    } else {
                                        oidParam = new OIDParameterVariable(strOid, CMTSMonitor.variableToObject(variable.getVariable()), variable.getSyntax(), this.packet.getIpAddress());
                                    }
                                } else {
                                    oidParam = new OIDParameterVariable(strOid, CMTSMonitor.variableToObject(variable.getVariable()), variable.getSyntax(), this.packet.getIpAddress());
                                }
                                modemStatus.oids.add(oidParam);
                            }
                        }
                    }
                    currentOid = variable.getOid().toString();
                }
                continue;
            }
            return null;
        }
        return this.postprocessData(modemMap);
    }

    @Override
    public boolean isDeviceLive(String address, Object monitor, Object object) throws SnmpResponseException {
        return true;
    }

    public void monitorDeviceParameters() throws UnknownHostException, InterruptedException {
    }

    public void setSnmpPoolManager(SnmpPoolManager snmpPoolManager) {
        this.snmpPoolManager = snmpPoolManager;
    }

    public SnmpPoolManager getSnmpPoolManager() {
        return this.snmpPoolManager;
    }

    class ModemStatus {
        Integer status;
        String mac;
        String ip;
        int upstreamIfIndex;
        int downstreamIfIndex;
        ArrayList<OIDParameterVariable> oids = new ArrayList();

        ModemStatus() {
        }
    }
}

