/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.devices;

import com.dsoft.powerpro.monitoring.mserver.reqeust.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitoring.mserver.reqeust.DeviceRequestPacket;
import com.dsoft.powerpro.monitorserver.devices.CMTSMonitor;
import com.dsoft.powerpro.monitorserver.snmp.BaseMonitoringThread;
import com.dsoft.powerpro.monitorserver.snmp.SnmpPoolManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;

public class CMTSMonitoringThread
extends BaseMonitoringThread {
    private static final Logger logger = Logger.getLogger(CMTSMonitoringThread.class.getName());
    private CMTSMonitor cmtsMonitor;

    public static String constructThreadId(DeviceOIDParameterPacket packet) {
        String id = "CMTS:" + packet.getDeviceId() + ":";
        if (packet.getQueueId() != null) {
            id = String.valueOf(id) + packet.getQueueId();
        }
        return id;
    }

    public CMTSMonitoringThread(DeviceOIDParameterPacket packet, long timeout, int monitorIteration, SnmpPoolManager snmpPoolManager) throws NamingException {
        super((DeviceRequestPacket)packet, timeout);
        this.cmtsMonitor = new CMTSMonitor((DeviceOIDParameterPacket)this.getPacket(), monitorIteration, snmpPoolManager);
    }

    @Override
    protected String getIdString() {
        return CMTSMonitoringThread.constructThreadId((DeviceOIDParameterPacket)this.getPacket());
    }

    @Override
    public void run() {
        boolean skipThisRound = false;
        long originalTimeOut = this.getTimeout();
        try {
            while (!this.isStoped()) {
                skipThisRound = this.checkMessageQueue(originalTimeOut);
                if (!skipThisRound) {
                    this.cmtsMonitor.readMonitoringValues();
                }
                try {
                    Thread.sleep(this.getTimeout());
                }
                catch (InterruptedException ex) {
                    this.stopThread();
                    return;
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void setSnmpPoolManager(SnmpPoolManager snmpPoolManager) {
        this.cmtsMonitor.setSnmpPoolManager(snmpPoolManager);
    }
}

