/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.devices;

import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.reqeust.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitoring.mserver.reqeust.DeviceRequestPacket;
import com.dsoft.powerpro.monitorserver.snmp.PoolTaskThread;
import com.dsoft.powerpro.monitorserver.snmp.SNMPRequestMonitor;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SNMPMonitoringThread
extends PoolTaskThread {
    private static final Logger logger = Logger.getLogger(SNMPMonitoringThread.class.getName());

    public static String constructThreadId(DeviceOIDParameterPacket packet, String explicitThrId) {
        String oid = null;
        String id = "Monitor:" + packet.getDeviceId() + ":";
        TreeSet<String> oids = new TreeSet<String>();
        if (explicitThrId == null && packet.getOidParameters() != null) {
            for (Object element : packet.getOidParameters()) {
                oid = ((OIDParameterVariable)element).getOidParameter().toString();
                oids.add(oid);
            }
            for (String oidstr : oids) {
                id = String.valueOf(id) + oidstr + ":";
            }
        } else {
            id = String.valueOf(id) + explicitThrId + ":";
        }
        if (packet.getQueueId() != null) {
            id = String.valueOf(id) + packet.getQueueId();
        }
        return id;
    }

    public SNMPMonitoringThread(DeviceOIDParameterPacket packet, long timeout) {
        super((DeviceRequestPacket)packet, timeout);
    }

    @Override
    protected String getIdString() {
        return SNMPMonitoringThread.constructThreadId((DeviceOIDParameterPacket)this.getPacket(), null);
    }

    @Override
    public void run() {
        try {
            this.incrementThreadExpiring(this.getPacket().getQueueId() != null ? 420000L : -System.currentTimeMillis());
            SNMPRequestMonitor snmpMonitor = new SNMPRequestMonitor((DeviceOIDParameterPacket)this.getPacket());
            while (!this.isStoped()) {
                snmpMonitor.monitorDeviceParameters();
                if (!this.isExpired()) {
                    try {
                        Thread.sleep(this.getTimeout());
                        continue;
                    }
                    catch (InterruptedException ex) {
                        this.stopThread();
                        return;
                    }
                }
                break;
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

