/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.icmp;

import com.dsoft.powerpro.monitorserver.MonitoringMethod;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ICMPMonitor
extends MonitoringMethod {
    private static final int DEFAULT_MAX_HOPS = 3;

    public ICMPMonitor() {
        super(3000, 4);
    }

    public ICMPMonitor(int timeout, int retry) {
        super(timeout, retry);
    }

    @Override
    public boolean isDeviceLive(String addres, Object monitor, Object object) throws InterruptedException, UnknownHostException {
        try {
            boolean res = false;
            InetAddress iNetAddres = InetAddress.getByName(addres);
            int i = 0;
            while (i < this.retry) {
                res = iNetAddres.isReachable(null, 3, this.timeout);
                if (res) break;
                ++i;
            }
            return res;
        }
        catch (UnknownHostException ex) {
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }
}

