/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.icmp;

import com.dsoft.powerpro.monitoring.mserver.reqeust.DeviceRequestPacket;
import com.dsoft.powerpro.monitoring.mserver.reqeust.ServerPingPacket;
import com.dsoft.powerpro.monitoring.mserver.response.PingResponsePacket;
import com.dsoft.powerpro.monitorserver.MonitoringMessageProcessor;
import com.dsoft.powerpro.monitorserver.snmp.PoolTaskThread;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ICMPPingThread
extends PoolTaskThread {
    private static final Logger LOGGER = Logger.getLogger(ICMPPingThread.class.getName());
    private static final Runtime rtime = Runtime.getRuntime();
    private static final String os = System.getProperty("os.name");

    public static String constructThreadId(DeviceRequestPacket packet) {
        String id = null;
        id = packet.getDeviceId() != null ? "" + packet.getDeviceId() : packet.getIpAddress();
        id = String.valueOf(id) + ":" + packet.getQueueId();
        return id;
    }

    public ICMPPingThread(ServerPingPacket pingPacket) {
        super((DeviceRequestPacket)pingPacket, 420000L);
    }

    private String createUnixPingCommand(ServerPingPacket packet) {
        StringBuffer buffer = new StringBuffer();
        if (packet.getIpAddress() == null || packet.getIpAddress().equals("")) {
            return null;
        }
        buffer.append("ping");
        if (packet.getPingCount() > 0) {
            buffer.append(" -c ");
            buffer.append(packet.getPingCount());
        }
        if (packet.getPacketSize() > 0) {
            buffer.append(" -s ");
            buffer.append(packet.getPacketSize());
        }
        if (packet.getTimeout() >= 1000) {
            buffer.append(" -i ");
            buffer.append(packet.getTimeout() / 1000);
        }
        buffer.append(" ");
        buffer.append(packet.getIpAddress());
        return buffer.toString();
    }

    private String createWindowsPingCommand(ServerPingPacket packet) {
        StringBuffer buffer = new StringBuffer();
        if (packet.getIpAddress() == null || packet.getIpAddress().equals("")) {
            return null;
        }
        buffer.append("ping ");
        if (packet.getPingCount() > 0) {
            buffer.append(" -n ");
            buffer.append(packet.getPingCount());
        }
        if (packet.getPacketSize() > 0) {
            buffer.append(" -l ");
            buffer.append(packet.getPacketSize());
        }
        if (packet.getTimeout() > 0) {
            buffer.append(" -w ");
            buffer.append(packet.getTimeout());
        }
        buffer.append(" ");
        buffer.append(packet.getIpAddress());
        return buffer.toString();
    }

    @Override
    protected String getIdString() {
        return ICMPPingThread.constructThreadId(this.getPacket());
    }

    public Process pingAddress(ServerPingPacket packet) {
        String pingCommand = null;
        if (os.toLowerCase().startsWith("linux") || os.toLowerCase().startsWith("unix")) {
            pingCommand = this.createUnixPingCommand(packet);
        } else if (os.toLowerCase().startsWith("windows")) {
            pingCommand = this.createWindowsPingCommand(packet);
        }
        if (pingCommand == null) {
            return null;
        }
        try {
            return rtime.exec(pingCommand);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            ServerPingPacket pingPacket = (ServerPingPacket)this.getPacket();
            Process process = this.pingAddress(pingPacket);
            if (process == null) {
                return;
            }
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                try {
                    do {
                        if (this.isStoped()) return;
                        String line = in.readLine();
                        if (line == null) {
                            return;
                        }
                        if (line.trim().length() <= 0) continue;
                        String response = String.valueOf(line) + "\n";
                        PingResponsePacket monPingPacket = new PingResponsePacket();
                        monPingPacket.setDeviceId(pingPacket.getDeviceId());
                        monPingPacket.setIpAddress(pingPacket.getIpAddress());
                        monPingPacket.setQueueId(pingPacket.getQueueId());
                        monPingPacket.setPingType(1);
                        monPingPacket.setPingResponse(response);
                        monPingPacket.setReceiveTime(Long.valueOf(System.currentTimeMillis()));
                        MonitoringMessageProcessor.getInstance().sendInfoPacket((Serializable)monPingPacket, monPingPacket.getQueueId() != null);
                    } while (!this.isExpired());
                    return;
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            }
            finally {
                process.destroy();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

