/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.icmp;

import com.dsoft.powerpro.agent.pool.PoolTask;
import com.dsoft.powerpro.monitoring.mserver.reqeust.DeviceRequestPacket;
import com.dsoft.powerpro.monitoring.mserver.reqeust.ServerPingPacket;
import com.dsoft.powerpro.monitorserver.MonitoringManager;
import com.dsoft.powerpro.monitorserver.ServerProperties;
import com.dsoft.powerpro.monitorserver.dto.SnmpConfigsDTO;
import com.dsoft.powerpro.monitorserver.icmp.ICMPPingThread;
import com.dsoft.powerpro.monitorserver.icmp.PingThreadPool;
import com.dsoft.powerpro.monitorserver.snmp.PoolTaskThread;
import com.dsoft.powerpro.monitorserver.snmp.SnmpPingThread;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.picocontainer.annotations.Inject;

public class PingPoolManager {
    private static final Logger logger = Logger.getLogger(PingPoolManager.class.getName());
    private PingThreadPool pool;
    private MonitoringManager monitoringManager;
    private ServerProperties serverProperties;

    @Inject
    public void setServerProperties(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    @PostConstruct
    public void start() {
        this.pool = new PingThreadPool(this.serverProperties.getIcmpPool());
    }

    public void addNewThread(ServerPingPacket pingPacket) {
        try {
            SnmpConfigsDTO dto;
            PoolTaskThread thread = null;
            thread = pingPacket.getPingType() == 1 ? new ICMPPingThread(pingPacket) : ((dto = this.monitoringManager.getDeviceSNMPConfig(pingPacket.getDeviceId())) != null ? new SnmpPingThread(pingPacket, dto, this) : new ICMPPingThread(pingPacket));
            this.pool.runTask(thread, true);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    @PreDestroy
    public void clearPool() {
        this.pool.close();
    }

    public String getPingThreadId(ServerPingPacket pingPacket) {
        if (pingPacket.getPingType() == 1) {
            return ICMPPingThread.constructThreadId((DeviceRequestPacket)pingPacket);
        }
        return SnmpPingThread.constructThreadId(pingPacket);
    }

    public void removeThread(ServerPingPacket pingPacket) {
        this.pool.removeTask(this.getPingThreadId(pingPacket));
    }

    @Inject
    public void setMonitoringManager(MonitoringManager monitoringManager) {
        this.monitoringManager = monitoringManager;
    }

    public void updateThreadExpirng(ServerPingPacket pingPacket) {
        PoolTask thread = this.pool.getTaskById(this.getPingThreadId(pingPacket));
        if (thread != null) {
            thread.incrementThreadExpiring(300000L);
        }
    }
}

