/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp;

import com.dsoft.powerpro.agent.pool.PoolTask;
import com.dsoft.powerpro.monitoring.mserver.reqeust.DeviceRequestPacket;

public abstract class PoolTaskThread
implements PoolTask {
    private DeviceRequestPacket packet;
    private long timeout;
    private boolean stoped = false;
    private String threadId;
    private Thread executionThread;
    private long threadExpiring = 0L;

    public PoolTaskThread(DeviceRequestPacket packet, long timeout) {
        this.packet = packet;
        this.timeout = timeout;
        this.threadId = this.getIdString();
        this.threadExpiring = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isExpired() {
        PoolTaskThread poolTaskThread = this;
        synchronized (poolTaskThread) {
            return this.threadExpiring > 0L ? System.currentTimeMillis() > this.threadExpiring : false;
        }
    }

    protected abstract String getIdString();

    public DeviceRequestPacket getPacket() {
        return this.packet;
    }

    @Override
    public String getThreadId() {
        return this.threadId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementThreadExpiring(long time) {
        PoolTaskThread poolTaskThread = this;
        synchronized (poolTaskThread) {
            this.threadExpiring = System.currentTimeMillis() + time;
        }
    }

    public boolean isStoped() {
        return this.stoped;
    }

    @Override
    public void setExecutionThread(Thread executionThread) {
        this.executionThread = executionThread;
    }

    @Override
    public void stopThread() {
        this.stoped = true;
        this.executionThread.interrupt();
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }
}

