/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp;

import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.reqeust.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitoring.mserver.response.OIDResponsePacket;
import com.dsoft.powerpro.monitorserver.MonitoringMessageProcessor;
import com.dsoft.powerpro.monitorserver.MonitoringMethod;
import com.dsoft.powerpro.monitorserver.snmp.SnmpResponseException;
import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.PDUFactory;

public class SNMPBaseMonitor
extends MonitoringMethod
implements PDUFactory {
    private static final String DOT = ".";
    private static final Logger LOGGER = Logger.getLogger(SNMPBaseMonitor.class.getName());
    protected String resultString;
    protected long pingResponseTime;
    protected long pingStartTime;
    protected DeviceOIDParameterPacket packet;
    protected Target monitTarget;
    protected PDU monitPdu;
    protected Address address;
    protected OID authProtocol;
    protected OID privProtocol;
    protected OctetString privPassphrase;
    protected OctetString authPassphrase;
    protected OctetString community = new OctetString("public");
    protected OctetString contextEngineID;
    protected OctetString contextName = new OctetString();
    protected OctetString securityName = new OctetString();
    protected TimeTicks sysUpTime = new TimeTicks(0L);
    protected OID trapOID = SnmpConstants.coldStart;
    protected PDUv1 v1TrapPDU = new PDUv1();
    protected int version = 0;
    protected int pduType = -95;
    protected int maxRepetitions = 10;
    protected int nonRepeaters = 0;
    private static final String ifNumber = "1.3.6.1.2.1.2.1";
    private static final String ifIndex = "1.3.6.1.2.1.2.2.1.1";
    protected static final String ifInOctets = "1.3.6.1.2.1.2.2.1.10";
    protected static final String ifOutOctets = "1.3.6.1.2.1.2.2.1.16";
    private List<OIDParameterVariable> ifIndexes = null;
    protected static final String ifType = "1.3.6.1.2.1.2.2.1.3";
    private static HashMap<SNMPSessionKey, Snmp> snmpSessionMap = new HashMap();
    private static final Object snmpSessionLock = new Object();

    private static OctetString createOctetString(String s) {
        OctetString octetString = s.startsWith("0x") ? OctetString.fromHexString((String)s.substring(2), (char)':') : new OctetString(s);
        return octetString;
    }

    public static Object variableToObject(Variable var) {
        if (var instanceof Null) {
            return null;
        }
        if (var instanceof Integer32) {
            return new Integer(((Integer32)var).getValue());
        }
        if (var instanceof Counter64) {
            return new Long(((Counter64)var).getValue());
        }
        if (var instanceof UnsignedInteger32) {
            return new Long(((UnsignedInteger32)var).getValue());
        }
        if (var instanceof OctetString) {
            return ((OctetString)var).toString();
        }
        if (var instanceof TimeTicks) {
            return new Long(((TimeTicks)var).getValue());
        }
        if (var instanceof OID) {
            return ((OID)var).toString();
        }
        if (var instanceof IpAddress) {
            return ((IpAddress)var).getInetAddress().getHostAddress();
        }
        if (var != null) {
            System.out.println(var.getClass().getName());
        }
        return null;
    }

    public SNMPBaseMonitor() {
        this(5000, 4);
    }

    public SNMPBaseMonitor(DeviceOIDParameterPacket packet) {
        this(5000, 4);
        this.packet = packet;
        this.baseInitialization();
    }

    public SNMPBaseMonitor(int timeout, int retry) {
        super(timeout, retry);
    }

    protected void addUsmUser(Snmp snmp) {
        snmp.getUSM().addUser(this.securityName, new UsmUser(this.securityName, this.authProtocol, this.authPassphrase, this.privProtocol, this.privPassphrase));
    }

    private void baseInitialization() {
        int port = this.packet.getPort() != null && this.packet.getPort() != 0 ? this.packet.getPort() : 161;
        this.address = GenericAddress.parse((String)("udp:" + this.packet.getIpAddress() + "/" + port));
        this.retry = this.packet.getRetries() != null && this.packet.getRetries() > 0 ? this.packet.getRetries() : this.retry;
        this.timeout = this.packet.getTimeout() != null && this.packet.getTimeout() > 0L ? (int)this.packet.getTimeout().longValue() : this.timeout;
        switch (this.packet.getOidRequestType()) {
            case 0: {
                this.pduType = -96;
                break;
            }
            case 1: {
                this.pduType = -95;
                break;
            }
            case 2: {
                this.pduType = -93;
                break;
            }
            case 3: {
                this.pduType = -91;
                break;
            }
            default: {
                this.pduType = -95;
            }
        }
        this.community = this.pduType == -93 ? SNMPBaseMonitor.createOctetString(this.packet.getWriteCommunity() != null ? this.packet.getWriteCommunity() : "private") : SNMPBaseMonitor.createOctetString(this.packet.getReadCommunity() != null ? this.packet.getReadCommunity() : "public");
        if (this.packet.getSnmpVersion().equals("SNMP v.1")) {
            this.version = 0;
            this.initialize();
            return;
        }
        if (this.packet.getSnmpVersion().equals("SNMP v.2")) {
            this.version = 1;
            this.initialize();
            return;
        }
        if (!this.packet.getSnmpVersion().equals("SNMP v.3")) {
            throw new IllegalArgumentException("Version " + this.packet.getSnmpVersion() + " not supported");
        }
        this.version = 3;
        if (this.packet.getAuthProtocol() != null) {
            if (this.packet.getAuthProtocol().equals("MD5")) {
                this.authProtocol = AuthMD5.ID;
            } else if (this.packet.getAuthProtocol().equals("SHA")) {
                this.authProtocol = AuthSHA.ID;
            } else {
                throw new IllegalArgumentException("Authentication protocol unsupported: " + this.packet.getAuthProtocol());
            }
        }
        if (this.packet.getPrivProtocol() != null) {
            if (this.packet.getPrivProtocol().equals("DES")) {
                this.privProtocol = PrivDES.ID;
            } else if (this.packet.getPrivProtocol().equals("AES128") || this.packet.getPrivProtocol().equals("AES")) {
                this.privProtocol = PrivAES128.ID;
            } else if (this.packet.getPrivProtocol().equals("AES192")) {
                this.privProtocol = PrivAES192.ID;
            } else if (this.packet.getPrivProtocol().equals("AES256")) {
                this.privProtocol = PrivAES256.ID;
            } else {
                throw new IllegalArgumentException("Privacy protocol " + this.packet.getPrivProtocol() + " not supported");
            }
        }
        this.privPassphrase = SNMPBaseMonitor.createOctetString(this.packet.getPrivPassword());
        this.authPassphrase = SNMPBaseMonitor.createOctetString(this.packet.getAuthPassword());
        this.contextEngineID = SNMPBaseMonitor.createOctetString(this.packet.getContextId());
        this.contextName = SNMPBaseMonitor.createOctetString(this.packet.getContextName());
        this.securityName = new OctetString();
        this.initialize();
    }

    public PDU createPDU(Target target) {
        Object request;
        if (target.getVersion() == 3) {
            ScopedPDU scopedPDU = request = new ScopedPDU();
            if (this.contextEngineID != null) {
                scopedPDU.setContextEngineID(this.contextEngineID);
            }
            if (this.contextName != null) {
                scopedPDU.setContextName(this.contextName);
            }
        } else {
            request = this.pduType == -92 ? this.v1TrapPDU : new PDU();
        }
        request.setType(this.pduType);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Snmp getSnmpSession(String addressType, int version) throws UnknownHostException, IOException {
        SNMPSessionKey key = new SNMPSessionKey(addressType, "" + version);
        Object object = snmpSessionLock;
        synchronized (object) {
            if (snmpSessionMap.containsKey(key)) {
                ArrayList keyList = new ArrayList(snmpSessionMap.keySet());
                key = (SNMPSessionKey)keyList.get(keyList.indexOf(key));
                key.lock();
                return snmpSessionMap.get(key);
            }
        }
        Object transport = this.address instanceof TcpAddress ? new DefaultTcpTransportMapping() : new DefaultUdpTransportMapping();
        Snmp snmp = new Snmp((TransportMapping)transport);
        if (version == 3) {
            USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
            SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
            this.addUsmUser(snmp);
        }
        Object object2 = snmpSessionLock;
        synchronized (object2) {
            snmpSessionMap.put(key, snmp);
            key.lock();
            key.startSession();
            snmp.listen();
        }
        return snmp;
    }

    protected Snmp getSnmpSession() throws IOException {
        String addressType = "UDP";
        if (this.address instanceof TcpAddress) {
            addressType = "TCP";
        }
        return this.getSnmpSession(addressType, this.version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeSession(Snmp session) {
        Object object = snmpSessionLock;
        synchronized (object) {
            for (SNMPSessionKey key : snmpSessionMap.keySet()) {
                if (snmpSessionMap.get(key) != session) continue;
                key.unlock();
                break;
            }
        }
    }

    private Target createTarget() {
        if (this.version == 3) {
            UserTarget target = new UserTarget();
            if (this.authPassphrase != null) {
                if (this.privPassphrase != null) {
                    target.setSecurityLevel(3);
                } else {
                    target.setSecurityLevel(2);
                }
            } else {
                target.setSecurityLevel(1);
            }
            target.setSecurityName(this.securityName);
            return target;
        }
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(this.community);
        return target;
    }

    protected List<OIDParameterVariable> getIfIndexes(Snmp snmpSession, boolean reset) throws IOException {
        if (this.ifIndexes != null && !reset) {
            return this.ifIndexes;
        }
        this.ifIndexes = new ArrayList<OIDParameterVariable>();
        int interfaces = 0;
        this.monitPdu.clear();
        this.monitPdu.setType(-95);
        this.monitPdu.add(new VariableBinding(new OID(ifNumber)));
        ResponseEvent event = snmpSession.send(this.monitPdu, this.monitTarget, null);
        PDU response = event.getResponse();
        if (response != null) {
            Vector variables = response.getVariableBindings();
            VariableBinding ifNumberValue = (VariableBinding)variables.get(0);
            if (ifNumberValue.getOid().startsWith(new OID(ifNumber))) {
                interfaces = Integer.parseInt(ifNumberValue.getVariable().toString());
            }
        } else {
            return this.ifIndexes;
        }
        if (this.version == 0) {
            this.monitPdu.setType(-95);
        } else {
            this.monitPdu.setType(-91);
            this.monitPdu.setMaxRepetitions(interfaces);
        }
        String currentOid = ifIndex;
        while (currentOid.startsWith(ifIndex)) {
            this.monitPdu.getVariableBindings().clear();
            this.monitPdu.add(new VariableBinding(new OID(currentOid)));
            event = snmpSession.send(this.monitPdu, this.monitTarget, null);
            response = event.getResponse();
            if (response == null || response.getErrorStatus() != 0 || response.getType() == -88) break;
            Vector variables = response.getVariableBindings();
            for (VariableBinding varBinding : variables) {
                String oid = varBinding.getOid().toString();
                if (oid.startsWith(ifIndex)) {
                    this.ifIndexes.add(new OIDParameterVariable(oid, SNMPBaseMonitor.variableToObject(varBinding.getVariable()), varBinding.getSyntax(), this.packet.getIpAddress()));
                    if (!currentOid.startsWith(ifIndex)) continue;
                    currentOid = oid;
                    continue;
                }
                currentOid = oid;
            }
        }
        return this.ifIndexes;
    }

    public HashMap<String, OIDParameterVariable> getOidTableVariables(Snmp snmpSession, HashSet<String> variablesToGet, boolean includeIndex) throws IOException {
        HashMap<String, OIDParameterVariable> result = new HashMap<String, OIDParameterVariable>();
        if (this.version == 0) {
            this.monitPdu.setType(-95);
        } else {
            this.monitPdu.setType(-91);
            this.monitPdu.setMaxRepetitions(10);
        }
        int retries = 0;
        Iterator<String> iterator = variablesToGet.iterator();
        block0: while (iterator.hasNext()) {
            String variableOid;
            String currentOid = variableOid = iterator.next();
            while (currentOid.startsWith(variableOid)) {
                this.monitPdu.getVariableBindings().clear();
                this.monitPdu.add(new VariableBinding(new OID(currentOid)));
                if (Thread.currentThread().isInterrupted()) {
                    return result;
                }
                String lastOid = this.processResponse(includeIndex, result, variableOid, currentOid, snmpSession);
                if (lastOid.equals(currentOid)) {
                    if (++retries <= 3) continue;
                    continue block0;
                }
                currentOid = lastOid;
            }
        }
        return result;
    }

    protected HashMap<String, OIDParameterVariable> getOidVariables(Snmp snmpSession, HashSet<String> variablesToGet, boolean inludeIndex) throws IOException {
        this.monitPdu.setType(-96);
        HashMap<String, OIDParameterVariable> result = new HashMap<String, OIDParameterVariable>();
        int tries = 0;
        while (!variablesToGet.isEmpty() && tries < 5) {
            this.monitPdu.getVariableBindings().clear();
            for (String variableOid : variablesToGet) {
                this.monitPdu.add(new VariableBinding(new OID(variableOid)));
                if (this.monitPdu.getVariableBindings().size() > 10) break;
            }
            if (Thread.currentThread().isInterrupted()) {
                return result;
            }
            ResponseEvent event = snmpSession.send(this.monitPdu, this.monitTarget, null);
            PDU response = event.getResponse();
            if (response != null) {
                Vector variables = event.getResponse().getVariableBindings();
                if (!variables.isEmpty()) {
                    for (VariableBinding variable : variables) {
                        String paramName = variable.getOid().toString();
                        variablesToGet.remove(paramName);
                        String oid = paramName;
                        if (!inludeIndex) {
                            oid = paramName.substring(0, paramName.lastIndexOf(DOT));
                        }
                        result.put(paramName, new OIDParameterVariable(oid, SNMPBaseMonitor.variableToObject(variable.getVariable()), variable.getSyntax(), this.packet.getIpAddress()));
                    }
                    continue;
                }
                ++tries;
                continue;
            }
            ++tries;
        }
        return result;
    }

    public long getPingStartTime() {
        return this.pingStartTime;
    }

    public long getResponseTime() {
        return this.pingResponseTime;
    }

    public String getResultString() {
        return this.resultString;
    }

    private void initialize() {
        this.maxRepetitions = this.packet.getMaxRepetitions() != null ? this.packet.getMaxRepetitions() : 1;
        this.nonRepeaters = this.packet.getNonRepeaters() != null ? this.packet.getNonRepeaters() : 0;
        this.monitTarget = this.createTarget();
        this.monitTarget.setVersion(this.version);
        this.monitTarget.setAddress(this.address);
        this.monitTarget.setRetries(this.retry);
        this.monitTarget.setTimeout((long)this.timeout);
        this.monitPdu = this.createPDU(this.monitTarget);
        if (this.packet.getOidParameters() == null || this.packet.getOidParameters().isEmpty()) {
            this.monitPdu.add(new VariableBinding(new OID()));
        } else {
            for (OIDParameterVariable oid : this.packet.getOidParameters()) {
                if (oid.getOidParameter() == null) continue;
                VariableBinding vb = new VariableBinding();
                vb.setOid(new OID(oid.getOidParameter().toString()));
                if (oid.getOidVariable() != null) {
                    Null variable;
                    switch (oid.getType()) {
                        case 2: {
                            variable = new Integer32(((Integer)oid.getOidVariable()).intValue());
                            break;
                        }
                        case 65: {
                            variable = new Counter32(((Long)oid.getOidVariable()).longValue());
                            break;
                        }
                        case 66: {
                            variable = new Gauge32(((Long)oid.getOidVariable()).longValue());
                            break;
                        }
                        case 70: {
                            variable = new Counter64(((Long)oid.getOidVariable()).longValue());
                            break;
                        }
                        case 4: {
                            variable = new OctetString((String)oid.getOidVariable());
                            break;
                        }
                        case 5: {
                            variable = new Null();
                            break;
                        }
                        case 6: {
                            variable = new OID((String)oid.getOidVariable());
                            break;
                        }
                        case 67: {
                            variable = new TimeTicks(((Long)oid.getOidVariable()).longValue());
                            break;
                        }
                        case 64: {
                            variable = new IpAddress((String)oid.getOidVariable());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Variable type not supported");
                        }
                    }
                    vb.setVariable((Variable)variable);
                }
                this.monitPdu.add(vb);
            }
        }
        if (this.monitPdu.getType() == -91) {
            this.monitPdu.setMaxRepetitions(this.maxRepetitions);
            this.monitPdu.setNonRepeaters(this.nonRepeaters);
        }
    }

    @Override
    public boolean isDeviceLive(String address, Object monitor, Object object) throws SnmpResponseException {
        return true;
    }

    private String processResponse(boolean includeIndex, HashMap<String, OIDParameterVariable> result, String variableOid, String currentOid, Snmp snmpSession) throws IOException {
        Vector variables;
        PDU response;
        ResponseEvent event = snmpSession.send(this.monitPdu, this.monitTarget, null);
        if (event != null && (response = event.getResponse()) != null && !(variables = event.getResponse().getVariableBindings()).isEmpty()) {
            for (VariableBinding varBidning : variables) {
                String paramName;
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, String.format("Received response %1$s from : %2$s", varBidning.toString(), event.getPeerAddress()));
                }
                if ((paramName = varBidning.getOid().toString()).contains(variableOid)) {
                    String oid = paramName;
                    if (!includeIndex) {
                        oid = paramName.substring(0, paramName.lastIndexOf(DOT));
                    }
                    result.put(paramName, new OIDParameterVariable(oid, SNMPBaseMonitor.variableToObject(varBidning.getVariable()), varBidning.getSyntax(), this.packet.getIpAddress()));
                    if (!currentOid.startsWith(currentOid)) continue;
                    currentOid = paramName;
                    continue;
                }
                currentOid = paramName;
            }
        }
        return currentOid;
    }

    protected HashMap<Integer, Integer> readInterfaceIOStats(Snmp snmpSession, List<OIDParameterVariable> oids, int[] interfaceTypes) throws IOException {
        HashSet<String> variablesToGet = new HashSet<String>();
        if (interfaceTypes != null && interfaceTypes.length > 0) {
            variablesToGet.add(ifType);
        }
        variablesToGet.add(ifInOctets);
        variablesToGet.add(ifOutOctets);
        HashMap<String, OIDParameterVariable> getResult = this.getOidTableVariables(snmpSession, variablesToGet, true);
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        if (getResult != null && !getResult.isEmpty()) {
            HashSet<String> indexToProcess = new HashSet<String>();
            if (interfaceTypes != null && interfaceTypes.length > 0) {
                for (String paramName : getResult.keySet()) {
                    if (!paramName.startsWith(ifType)) continue;
                    OIDParameterVariable ifTypeVariable = getResult.get(paramName);
                    String index = paramName.substring(paramName.lastIndexOf(DOT), paramName.length());
                    Integer ifType = (Integer)ifTypeVariable.getOidVariable();
                    result.put(Integer.parseInt(index.substring(1)), ifType);
                    int[] nArray = interfaceTypes;
                    int n = interfaceTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int intfType = nArray[n2];
                        if (intfType == ifType) {
                            oids.add(ifTypeVariable);
                            indexToProcess.add(index);
                        }
                        ++n2;
                    }
                }
                for (String index : indexToProcess) {
                    if (getResult.containsKey(ifInOctets + index)) {
                        oids.add(getResult.get(ifInOctets + index));
                    }
                    if (!getResult.containsKey(ifOutOctets + index)) continue;
                    oids.add(getResult.get(ifOutOctets + index));
                }
            } else {
                oids.addAll(getResult.values());
            }
        }
        return result;
    }

    public void sendOidVariablePacket(String requestMarker, Integer deviceId, List<OIDParameterVariable> oids, Integer monitorIteration) {
        OIDResponsePacket monitorPacket = new OIDResponsePacket(requestMarker);
        monitorPacket.setDeviceId(deviceId);
        monitorPacket.setQueueId(this.packet.getQueueId());
        monitorPacket.setOidParameters(oids);
        monitorPacket.setMonitorIteration(monitorIteration);
        MonitoringMessageProcessor.getInstance().sendInfoPacket((Serializable)monitorPacket, this.packet.getQueueId() != null);
    }

    class SNMPSessionKey {
        private String addressType;
        private long lastTimeUsed;
        private int lockCount = 0;
        private String version;

        public int unlock() {
            this.lastTimeUsed = System.currentTimeMillis();
            return --this.lockCount;
        }

        public void lock() {
            this.lastTimeUsed = System.currentTimeMillis();
            ++this.lockCount;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.addressType == null ? 0 : this.addressType.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SNMPSessionKey other = (SNMPSessionKey)obj;
            if (this.addressType == null ? other.addressType != null : !this.addressType.equals(other.addressType)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }

        SNMPSessionKey(String addressType, String version) {
            this.addressType = addressType;
            this.version = version;
        }

        public void startSession() {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ex1) {
                            break;
                        }
                        if (System.currentTimeMillis() - SNMPSessionKey.this.lastTimeUsed <= 10000L || SNMPSessionKey.this.lockCount != 0) continue;
                        Object object = snmpSessionLock;
                        synchronized (object) {
                            try {
                                ((Snmp)snmpSessionMap.remove(SNMPSessionKey.this)).close();
                                break;
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                            }
                        }
                    }
                }
            }.start();
        }
    }
}

