/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp;

import com.dsoft.powerpro.monitoring.mserver.reqeust.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitoring.mserver.reqeust.DeviceRequestPacket;
import com.dsoft.powerpro.monitorserver.snmp.BaseMonitoringThread;
import com.dsoft.powerpro.monitorserver.snmp.SNMPTrafficMonitor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;

public class SNMPTrafficMinitoringThread
extends BaseMonitoringThread {
    private static final Logger logger = Logger.getLogger(SNMPTrafficMinitoringThread.class.getName());
    private int monitorIteration;
    long originalTimeOut;

    public static String constructThreadId(DeviceOIDParameterPacket packet) {
        String id = "SNMP:" + packet.getDeviceId() + ":";
        if (packet.getQueueId() != null) {
            id = String.valueOf(id) + packet.getQueueId();
        }
        return id;
    }

    public SNMPTrafficMinitoringThread(DeviceOIDParameterPacket packet, long timeout, int monitorIteration) throws NamingException {
        super((DeviceRequestPacket)packet, timeout);
        this.monitorIteration = monitorIteration;
    }

    @Override
    protected String getIdString() {
        return SNMPTrafficMinitoringThread.constructThreadId((DeviceOIDParameterPacket)this.getPacket());
    }

    @Override
    public void run() {
        boolean skipThisRound = false;
        this.originalTimeOut = this.getTimeout();
        try {
            SNMPTrafficMonitor snmpTrafficMonitor = new SNMPTrafficMonitor((DeviceOIDParameterPacket)this.getPacket(), this.monitorIteration);
            while (!this.isStoped()) {
                skipThisRound = this.checkMessageQueue(this.originalTimeOut);
                if (!skipThisRound) {
                    snmpTrafficMonitor.getOIDParameters();
                }
                try {
                    Thread.sleep(this.getTimeout());
                }
                catch (InterruptedException ex) {
                    this.stopThread();
                    return;
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

