/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp;

import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.reqeust.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitorserver.MonitoringManager;
import com.dsoft.powerpro.monitorserver.snmp.SNMPBaseMonitor;
import com.dsoft.powerpro.monitorserver.snmp.SnmpResponseException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.snmp4j.Snmp;

public class SNMPTrafficMonitor
extends SNMPBaseMonitor {
    private static final Logger logger = Logger.getLogger(SNMPTrafficMonitor.class.getName());
    private int monitorIteration;

    public SNMPTrafficMonitor() {
    }

    public SNMPTrafficMonitor(DeviceOIDParameterPacket packet, int monitorIteration) {
        super(packet);
        this.monitorIteration = monitorIteration;
    }

    public SNMPTrafficMonitor(int timeout, int retry) {
        super(timeout, retry);
    }

    public void getOIDParameters() {
        Snmp snmpSession = null;
        try {
            snmpSession = this.getSnmpSession();
            try {
                this.monitPdu.clear();
                ++this.monitorIteration;
                MonitoringManager.getInstance().incrementMonitorIteration(this.packet.getDeviceId(), new Integer(this.monitorIteration));
                ArrayList<OIDParameterVariable> oids = new ArrayList<OIDParameterVariable>();
                this.readInterfaceIOStats(snmpSession, oids, new int[]{127, 6, 160, 117});
                this.sendOidVariablePacket(null, this.packet.getDeviceId(), oids, new Integer(this.monitorIteration));
            }
            finally {
                this.closeSession(snmpSession);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            ex.printStackTrace();
        }
    }

    @Override
    public boolean isDeviceLive(String address, Object monitor, Object object) throws SnmpResponseException {
        return true;
    }

    public void monitorDeviceParameters() throws UnknownHostException, InterruptedException {
    }
}

