/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp;

import com.dsoft.powerpro.internet.mserver.queue.MessageQueue;
import com.dsoft.powerpro.monitorserver.snmp.SnmpComandResponderImpl;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.snmp4j.CommandResponder;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SNMPTrapServer
implements Runnable {
    private Thread trapServerThread;
    private static final Logger logger = Logger.getLogger(SNMPTrapServer.class.getName());
    SnmpComandResponderImpl trapResponder;

    public SNMPTrapServer(ThreadGroup threadGroup, MessageQueue messageQueue) {
        this.trapServerThread = new Thread(threadGroup, this, "SNMP Trap Server thread");
        this.trapResponder = new SnmpComandResponderImpl(messageQueue);
    }

    @PostConstruct
    public void start() {
        this.trapServerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DefaultUdpTransportMapping transport = null;
        Snmp snmpSession = null;
        try {
            try {
                transport = new DefaultUdpTransportMapping(new UdpAddress("0.0.0.0/162"));
                snmpSession = new Snmp((TransportMapping)transport);
                snmpSession.addCommandResponder((CommandResponder)this.trapResponder);
                transport.listen();
                try {
                    logger.info("Waiting for Trap ...");
                    do {
                        SnmpComandResponderImpl snmpComandResponderImpl = this.trapResponder;
                        synchronized (snmpComandResponderImpl) {
                            this.trapResponder.wait();
                            if (!Thread.currentThread().isInterrupted()) {
                                logger.log(Level.FINE, "Recive Trap");
                            }
                        }
                    } while (!Thread.currentThread().isInterrupted());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
        finally {
            if (snmpSession != null) {
                try {
                    snmpSession.close();
                    logger.info("ClosingSession Trap");
                }
                catch (IOException iOException) {}
            }
        }
    }

    @PreDestroy
    public void stopServer() {
        this.trapServerThread.interrupt();
    }
}

