/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp;

import com.dsoft.powerpro.internet.client.InternetUtils;
import com.dsoft.powerpro.internet.mserver.queue.MessageQueue;
import com.dsoft.powerpro.monitoring.mserver.response.TrapPacket;
import com.dsoft.powerpro.monitorserver.Constants;
import com.dsoft.powerpro.monitorserver.MonitoringManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;

public class SnmpComandResponderImpl
implements CommandResponder {
    private static final Logger logger = Logger.getLogger(SnmpComandResponderImpl.class.getName());
    private MessageQueue messageQueue;

    public SnmpComandResponderImpl(MessageQueue messageQueue) {
        this.messageQueue = messageQueue;
    }

    private void loggGenericTrap(String inetAddress, PDUv1 snmpPduTrap) {
        int code = snmpPduTrap.getGenericTrap();
        String objectId = snmpPduTrap.getEnterprise().toString();
        String genericTrap = code >= 0 && code <= 6 ? Constants.genericTraps[code] : "Unknown Generic Code";
        try {
            long ipLong = InternetUtils.ipStringToLong((String)inetAddress);
            Integer deviceId = MonitoringManager.getInstance().getDeviceId(ipLong);
            TrapPacket trapPacket = new TrapPacket();
            trapPacket.setGenericTrap(genericTrap);
            trapPacket.setIpAddress(inetAddress);
            trapPacket.setObjectId(objectId);
            trapPacket.setDeviceId(deviceId);
            this.messageQueue.postMessage((Object)trapPacket, Integer.valueOf(0), -1L, null, false);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processPdu(CommandResponderEvent e) {
        SnmpComandResponderImpl snmpComandResponderImpl = this;
        synchronized (snmpComandResponderImpl) {
            this.notifyAll();
        }
        logger.info("Peer Address " + e.getPeerAddress().toString());
        PDU pdu = null;
        if (e.getPDU() != null) {
            pdu = e.getPDU();
            if (pdu.getErrorStatus() == 5) {
                logger.log(Level.SEVERE, pdu.getErrorStatusText());
                return;
            }
            if (pdu.getType() == -92) {
                PDUv1 pduV1 = (PDUv1)pdu;
                this.loggGenericTrap(pduV1.getAgentAddress().getInetAddress().getCanonicalHostName(), pduV1);
            } else if (pdu.getType() == -89) {
                System.out.println(pdu.getClass().getSimpleName());
            } else if (pdu.getType() == -88) {
                System.out.println(pdu.getClass().getSimpleName());
            }
        }
    }
}

