/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp;

import com.dsoft.powerpro.monitoring.mserver.reqeust.DeviceRequestPacket;
import com.dsoft.powerpro.monitoring.mserver.reqeust.ServerPingPacket;
import com.dsoft.powerpro.monitoring.mserver.response.PingResponsePacket;
import com.dsoft.powerpro.monitorserver.MonitoringMessageProcessor;
import com.dsoft.powerpro.monitorserver.dto.SnmpConfigsDTO;
import com.dsoft.powerpro.monitorserver.icmp.PingPoolManager;
import com.dsoft.powerpro.monitorserver.snmp.PoolTaskThread;
import com.dsoft.powerpro.monitorserver.snmp.SNMPRequestMonitor;
import com.dsoft.powerpro.monitorserver.snmp.SnmpResponseException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SnmpPingThread
extends PoolTaskThread {
    private static final Logger LOGGER = Logger.getLogger(SnmpPingThread.class.getName());
    private SnmpConfigsDTO confDto;
    private PingPoolManager pingPoolManager;

    public static String constructThreadId(ServerPingPacket packet) {
        String id = "Ping:";
        id = packet.getDeviceId() != null ? "" + packet.getDeviceId() : packet.getIpAddress();
        id = String.valueOf(id) + ":" + packet.getQueueId();
        return id;
    }

    public SnmpPingThread(ServerPingPacket pingPacket, SnmpConfigsDTO confDto, PingPoolManager pingPoolManager) {
        super((DeviceRequestPacket)pingPacket, -1L);
        this.confDto = confDto;
        this.pingPoolManager = pingPoolManager;
    }

    @Override
    protected String getIdString() {
        return SnmpPingThread.constructThreadId(this.getPingPacket());
    }

    private ServerPingPacket getPingPacket() {
        return (ServerPingPacket)this.getPacket();
    }

    @Override
    public void run() {
        try {
            this.incrementThreadExpiring(420000L);
            SNMPRequestMonitor snmpMonitor = new SNMPRequestMonitor((int)this.getPingPacket().getMinWaitTime().longValue(), 0);
            String response = null;
            long minWaitTime = this.getPingPacket().getTimeout().intValue();
            while (!this.isStoped()) {
                response = snmpMonitor.isDeviceLive(this.getPingPacket().getIpAddress(), null, this.confDto) ? snmpMonitor.getResultString() : "Request timed out";
                long start = snmpMonitor.getPingStartTime();
                long currentTime = System.currentTimeMillis();
                PingResponsePacket monPingPacket = new PingResponsePacket();
                monPingPacket.setDeviceId(this.getPingPacket().getDeviceId());
                monPingPacket.setIpAddress(this.getPingPacket().getIpAddress());
                monPingPacket.setQueueId(this.getPingPacket().getQueueId());
                monPingPacket.setPingType(2);
                monPingPacket.setPingResponse(response);
                monPingPacket.setReceiveTime(Long.valueOf(currentTime));
                MonitoringMessageProcessor.getInstance().sendInfoPacket((Serializable)monPingPacket, monPingPacket.getQueueId() != null);
                if (!this.isExpired()) {
                    long interval = currentTime - start;
                    if (interval >= minWaitTime) continue;
                    try {
                        Thread.sleep(minWaitTime - interval);
                        continue;
                    }
                    catch (InterruptedException ex1) {
                        return;
                    }
                }
                break;
            }
        }
        catch (SnmpResponseException ex) {
            this.stopThread();
            this.startPingThread();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private void startPingThread() {
        this.getPingPacket().setPingType(1);
        this.pingPoolManager.addNewThread(this.getPingPacket());
    }
}

