/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp;

import com.dsoft.powerpro.internet.client.InternetUtils;
import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.response.OIDResponsePacket;
import com.dsoft.powerpro.monitorserver.MonitoringManager;
import com.dsoft.powerpro.monitorserver.MonitoringMessageProcessor;
import com.dsoft.powerpro.monitorserver.snmp.SNMPBaseMonitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class SnmpResponseListenerImpl
implements ResponseListener {
    private static final Logger LOGGER = Logger.getLogger(SnmpResponseListenerImpl.class.getName());
    private Object errorResult;
    private Integer queueId;
    private String requestMarker;
    private Integer deviceId;
    private boolean hasResponse = false;

    protected static void printReport(PDU response) {
        if (response.size() < 1) {
            System.out.println("REPORT PDU does not contain a variable binding.");
            return;
        }
        VariableBinding vb = response.get(0);
        OID oid = vb.getOid();
        if (SnmpConstants.usmStatsUnsupportedSecLevels.equals((Object)oid)) {
            System.out.print("REPORT: Unsupported Security Level.");
        } else if (SnmpConstants.usmStatsNotInTimeWindows.equals((Object)oid)) {
            System.out.print("REPORT: Message not within time window.");
        } else if (SnmpConstants.usmStatsUnknownUserNames.equals((Object)oid)) {
            System.out.print("REPORT: Unknown user name.");
        } else if (SnmpConstants.usmStatsUnknownEngineIDs.equals((Object)oid)) {
            System.out.print("REPORT: Unknown engine id.");
        } else if (SnmpConstants.usmStatsWrongDigests.equals((Object)oid)) {
            System.out.print("REPORT: Wrong digest.");
        } else if (SnmpConstants.usmStatsDecryptionErrors.equals((Object)oid)) {
            System.out.print("REPORT: Decryption error.");
        } else if (SnmpConstants.snmpUnknownSecurityModels.equals((Object)oid)) {
            System.out.print("REPORT: Unknown security model.");
        } else if (SnmpConstants.snmpInvalidMsgs.equals((Object)oid)) {
            System.out.print("REPORT: Invalid message.");
        } else if (SnmpConstants.snmpUnknownPDUHandlers.equals((Object)oid)) {
            System.out.print("REPORT: Unknown PDU handler.");
        } else if (SnmpConstants.snmpUnavailableContexts.equals((Object)oid)) {
            System.out.print("REPORT: Unavailable context.");
        } else if (SnmpConstants.snmpUnknownContexts.equals((Object)oid)) {
            System.out.print("REPORT: Unknown context.");
        } else {
            System.out.print("REPORT contains unknown OID (" + oid.toString() + ").");
        }
    }

    public Object getErrorResult() {
        return this.errorResult;
    }

    public boolean hasResponse() {
        return this.hasResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(ResponseEvent responseEvent) {
        block36: {
            block33: {
                ArrayList<OIDParameterVariable> list;
                block35: {
                    Object varBinding2;
                    String remoteAddress;
                    PDU pduResponse;
                    block34: {
                        pduResponse = responseEvent.getResponse();
                        ((Snmp)responseEvent.getSource()).cancel(responseEvent.getRequest(), (ResponseListener)this);
                        remoteAddress = null;
                        if (responseEvent.getPeerAddress() != null && (remoteAddress = responseEvent.getPeerAddress().toString()).indexOf("/") > 0) {
                            remoteAddress = remoteAddress.substring(0, remoteAddress.indexOf("/"));
                        }
                        if (pduResponse == null) {
                            this.errorResult = "Request timed out";
                            LOGGER.log(Level.FINE, " Request timed out ");
                            break block33;
                        }
                        if (pduResponse.getType() != -88) break block34;
                        SnmpResponseListenerImpl snmpResponseListenerImpl = this;
                        synchronized (snmpResponseListenerImpl) {
                            this.notifyAll();
                        }
                        SnmpResponseListenerImpl.printReport(pduResponse);
                        SnmpResponseListenerImpl snmpResponseListenerImpl2 = this;
                        synchronized (snmpResponseListenerImpl2) {
                            this.notifyAll();
                        }
                        return;
                    }
                    Vector variables = pduResponse.getVariableBindings();
                    if (LOGGER.isLoggable(Level.FINER)) {
                        Iterator it = variables.iterator();
                        while (it.hasNext()) {
                            LOGGER.log(Level.FINER, String.format("Received response %1$s from: %2$s", it.next(), responseEvent.getPeerAddress()));
                        }
                    }
                    this.errorResult = pduResponse.getErrorStatus() == 0 ? ((VariableBinding)pduResponse.getVariableBindings().get(0)).getVariable().toString() : new Integer(pduResponse.getErrorStatus());
                    list = new ArrayList<OIDParameterVariable>();
                    for (Object varBinding2 : variables) {
                        this.hasResponse = true;
                        Variable var = varBinding2.getVariable();
                        list.add(new OIDParameterVariable(varBinding2.getOid().toString(), SNMPBaseMonitor.variableToObject(var), varBinding2.getSyntax(), remoteAddress));
                    }
                    if (this.requestMarker != null) break block35;
                    varBinding2 = this;
                    synchronized (varBinding2) {
                        this.notifyAll();
                    }
                    SnmpResponseListenerImpl snmpResponseListenerImpl = this;
                    synchronized (snmpResponseListenerImpl) {
                        this.notifyAll();
                    }
                    return;
                }
                try {
                    try {
                        OIDResponsePacket packet = new OIDResponsePacket(this.requestMarker);
                        packet.setOidParameters(list);
                        packet.setQueueId(this.queueId);
                        if (this.deviceId == null) {
                            long ipLong = 0L;
                            ipLong = InternetUtils.ipWithPortStringToLong((String)responseEvent.getPeerAddress().toString());
                            this.deviceId = MonitoringManager.getInstance().getDeviceId(ipLong);
                        }
                        packet.setDeviceId(this.deviceId);
                        MonitoringMessageProcessor.getInstance().sendInfoPacket((Serializable)packet, this.queueId != null);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                        SnmpResponseListenerImpl snmpResponseListenerImpl = this;
                        synchronized (snmpResponseListenerImpl) {
                            this.notifyAll();
                            break block36;
                        }
                    }
                }
                catch (Throwable throwable) {
                    SnmpResponseListenerImpl snmpResponseListenerImpl = this;
                    synchronized (snmpResponseListenerImpl) {
                        this.notifyAll();
                    }
                    throw throwable;
                }
            }
            SnmpResponseListenerImpl snmpResponseListenerImpl = this;
            synchronized (snmpResponseListenerImpl) {
                this.notifyAll();
            }
        }
    }

    public void setDeviceId(Integer deviceId) {
        this.deviceId = deviceId;
    }

    public void setQueueId(Integer queueId) {
        this.queueId = queueId;
    }

    public void setRequestMarker(String requestMarker) {
        this.requestMarker = requestMarker;
    }
}

