/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp.devices;

import com.dsoft.powerpro.internet.client.exception.InvalidIPFormatException;
import com.dsoft.powerpro.monitoring.mserver.reqeust.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitoring.mserver.reqeust.DeviceRequestPacket;
import com.dsoft.powerpro.monitoring.mserver.response.PingStatusPacket;
import com.dsoft.powerpro.monitorserver.MonitoringManager;
import com.dsoft.powerpro.monitorserver.MonitoringMessageProcessor;
import com.dsoft.powerpro.monitorserver.dto.DevicePingResponseDTO;
import com.dsoft.powerpro.monitorserver.dto.SnmpConfigsDTO;
import com.dsoft.powerpro.monitorserver.icmp.ICMPMonitor;
import com.dsoft.powerpro.monitorserver.snmp.PoolTaskThread;
import com.dsoft.powerpro.monitorserver.snmp.SNMPRequestMonitor;
import com.dsoft.powerpro.monitorserver.snmp.SnmpResponseException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DevicesMonitoringThread
extends PoolTaskThread {
    private static final Logger logger = Logger.getLogger(DevicesMonitoringThread.class.getName());
    private int pingType;
    private ICMPMonitor iCMPMonitor = null;
    private SNMPRequestMonitor sNMPtMonitor = null;

    public static String constructThreadId(DeviceOIDParameterPacket packet) {
        String id = "Device:" + packet.getDeviceId() + ":";
        if (packet.getQueueId() != null) {
            id = String.valueOf(id) + packet.getQueueId();
        }
        return id;
    }

    public DevicesMonitoringThread(DeviceOIDParameterPacket packet, long timeout, int pingType) {
        super((DeviceRequestPacket)packet, timeout);
        this.pingType = pingType;
    }

    private void changeDeviceStatus(String status, Integer deviecId, long endTime) throws Exception {
        PingStatusPacket packet = null;
        packet = new PingStatusPacket();
        packet.setDeviceId(deviecId);
        packet.setDeviceStatus(status);
        packet.setTimeStamp(endTime);
        MonitoringMessageProcessor.getInstance().sendInfoPacket((Serializable)packet, false);
    }

    private void doICMPReport() throws Exception, UnknownHostException, InterruptedException, InvalidIPFormatException {
        String ipAddress = this.getPacket().getIpAddress();
        boolean isAlive = this.iCMPMonitor.isDeviceLive(ipAddress, null, null);
        long endTime = System.currentTimeMillis();
        this.processDevicePing(endTime, isAlive);
    }

    private void doSnmpReport() throws Exception, UnknownHostException, InterruptedException {
        String ipAddress = this.getPacket().getIpAddress();
        SnmpConfigsDTO confDto = MonitoringManager.getInstance().getDeviceSNMPConfig(this.getPacket().getDeviceId());
        boolean isAlive = false;
        try {
            isAlive = this.sNMPtMonitor.isDeviceLive(ipAddress, null, confDto);
        }
        catch (SnmpResponseException ex) {
            this.doICMPReport();
            return;
        }
        long endTime = this.sNMPtMonitor.getResponseTime();
        this.processDevicePing(endTime, isAlive);
    }

    @Override
    protected String getIdString() {
        return DevicesMonitoringThread.constructThreadId((DeviceOIDParameterPacket)this.getPacket());
    }

    private void logReport(Integer devPingRepId, Integer deviceId, long startTime, long endTime) {
        try {
            MonitoringManager.getInstance().addDevicePingResponse(devPingRepId, deviceId, startTime, endTime);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private void processDevicePing(long endTime, boolean isAlive) {
        long cotrolTimeInterval = endTime - (this.getTimeout() + this.getTimeout() / 5L);
        try {
            DevicePingResponseDTO dto = MonitoringManager.getInstance().getDeviceLastPing(this.getPacket().getDeviceId());
            if (dto != null) {
                if (dto.getEndTime() < cotrolTimeInterval) {
                    if (dto.getEndTime() > cotrolTimeInterval - this.getTimeout()) {
                        if (!isAlive) {
                            this.changeDeviceStatus("deviceDown", this.getPacket().getDeviceId(), endTime);
                        } else {
                            this.logReport(null, this.getPacket().getDeviceId(), endTime, endTime);
                        }
                    } else if (isAlive) {
                        this.logReport(null, this.getPacket().getDeviceId(), endTime, endTime);
                        this.changeDeviceStatus("deviceUp", this.getPacket().getDeviceId(), endTime);
                    }
                } else if (isAlive) {
                    this.logReport(dto.getId(), this.getPacket().getDeviceId(), dto.getStartTime(), endTime);
                } else {
                    this.changeDeviceStatus("deviceWarning", this.getPacket().getDeviceId(), endTime);
                }
            } else if (isAlive) {
                this.logReport(null, this.getPacket().getDeviceId(), endTime, endTime);
                this.changeDeviceStatus("deviceUp", this.getPacket().getDeviceId(), endTime);
            } else {
                this.logReport(null, this.getPacket().getDeviceId(), endTime - this.getTimeout(), endTime - this.getTimeout());
                this.changeDeviceStatus("deviceWarning", this.getPacket().getDeviceId(), endTime);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    @Override
    public void run() {
        try {
            if (this.pingType == 0) {
                this.iCMPMonitor = new ICMPMonitor(3000, 1);
            } else {
                this.sNMPtMonitor = new SNMPRequestMonitor((DeviceOIDParameterPacket)this.getPacket());
            }
            while (!this.isStoped()) {
                if (this.pingType == 0) {
                    this.doICMPReport();
                } else {
                    this.doSnmpReport();
                }
                try {
                    Thread.sleep(this.getTimeout());
                }
                catch (InterruptedException ex) {
                    this.stopThread();
                    return;
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

