/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp.devices;

import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.reqeust.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitoring.mserver.reqeust.DeviceRequestPacket;
import com.dsoft.powerpro.monitorserver.snmp.PoolTaskThread;
import com.dsoft.powerpro.monitorserver.snmp.devices.IFTableRequest;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IFTableMonitoringThread
extends PoolTaskThread {
    private static final Logger logger = Logger.getLogger(IFTableMonitoringThread.class.getName());

    public static String constructThreadId(DeviceOIDParameterPacket packet, String explicitThrId) {
        String oid = null;
        String id = "Monitor:" + packet.getDeviceId() + ":";
        TreeSet<String> oids = new TreeSet<String>();
        if (explicitThrId == null && packet.getOidParameters() != null) {
            for (Object element : packet.getOidParameters()) {
                oid = ((OIDParameterVariable)element).getOidParameter().toString();
                oids.add(oid);
            }
            for (String oidStr : oids) {
                id = String.valueOf(id) + oidStr + ":";
            }
        } else {
            id = String.valueOf(id) + explicitThrId + ":";
        }
        if (packet.getQueueId() != null) {
            id = String.valueOf(id) + packet.getQueueId();
        }
        return id;
    }

    public IFTableMonitoringThread(DeviceOIDParameterPacket packet, long timeout) {
        super((DeviceRequestPacket)packet, timeout);
    }

    @Override
    protected String getIdString() {
        return IFTableMonitoringThread.constructThreadId((DeviceOIDParameterPacket)this.getPacket(), "ifTableThread");
    }

    @Override
    public void run() {
        try {
            this.incrementThreadExpiring(420000L);
            IFTableRequest snmpMonitor = new IFTableRequest((DeviceOIDParameterPacket)this.getPacket());
            snmpMonitor.initOIDSubtree(true);
            while (!this.isStoped()) {
                snmpMonitor.getIfTable();
                if (!this.isExpired()) {
                    try {
                        Thread.sleep(this.getTimeout());
                        continue;
                    }
                    catch (InterruptedException ex) {
                        this.stopThread();
                        return;
                    }
                }
                break;
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

