/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp.devices;

import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.reqeust.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitorserver.snmp.SNMPBaseMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

public class IFTableRequest
extends SNMPBaseMonitor {
    private static final Logger logger = Logger.getLogger(IFTableRequest.class.getName());
    private static final String ifTable = "1.3.6.1.2.1.2.2.1";
    private static final String ifAdminStatus = "1.3.6.1.2.1.2.2.1.7";
    private static final String ifDescr = "1.3.6.1.2.1.2.2.1.2";

    public IFTableRequest() {
    }

    public IFTableRequest(DeviceOIDParameterPacket packet) {
        super(packet);
    }

    public IFTableRequest(int timeout, int retry) {
        super(timeout, retry);
    }

    public void getIfTable() {
        Snmp snmpSession = null;
        try {
            snmpSession = this.getSnmpSession();
            try {
                this.monitPdu.clear();
                if (this.version == 0) {
                    this.getIfTableV1(snmpSession);
                } else {
                    this.getIfTableV2(snmpSession);
                }
            }
            finally {
                this.closeSession(snmpSession);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private void getIfTableV1(Snmp snmpSession) throws IOException {
        this.monitPdu.setType(-96);
        Iterator<OIDParameterVariable> it = this.getIfIndexes(snmpSession, false).iterator();
        while (it.hasNext() && !Thread.currentThread().isInterrupted()) {
            OIDParameterVariable param = it.next();
            String paramName = param.getOidParameter().toString();
            this.monitPdu.getVariableBindings().clear();
            int i = 7;
            while (i < 23) {
                this.monitPdu.add(new VariableBinding(new OID("1.3.6.1.2.1.2.2.1." + i + paramName.substring(paramName.lastIndexOf("."), paramName.length()))));
                ++i;
            }
            ArrayList<OIDParameterVariable> oids = new ArrayList<OIDParameterVariable>();
            oids.add(param);
            ResponseEvent event = snmpSession.send(this.monitPdu, this.monitTarget, null);
            PDU response = event.getResponse();
            if (response != null) {
                Vector variables = event.getResponse().getVariableBindings();
                for (VariableBinding variable : variables) {
                    oids.add(new OIDParameterVariable(variable.getOid().toString(), IFTableRequest.variableToObject(variable.getVariable()), variable.getSyntax(), this.packet.getIpAddress()));
                }
            }
            this.sendOidVariablePacket("IF_TABLE", this.packet.getDeviceId(), oids, null);
        }
    }

    private void getIfTableV2(Snmp snmpSession) throws IOException {
        this.monitPdu.setType(-91);
        this.monitPdu.setMaxRepetitions(this.getIfIndexes(snmpSession, false).size() * 2);
        this.monitPdu.getVariableBindings().clear();
        this.monitPdu.add(new VariableBinding(new OID(ifAdminStatus)));
        while (!Thread.currentThread().isInterrupted()) {
            PDU response;
            ArrayList<OIDParameterVariable> oids = new ArrayList<OIDParameterVariable>();
            ResponseEvent event = snmpSession.send(this.monitPdu, this.monitTarget, null);
            if (event == null || (response = event.getResponse()) == null) break;
            Vector variables = event.getResponse().getVariableBindings();
            VariableBinding lastVariable = null;
            Iterator iterator = variables.iterator();
            while (iterator.hasNext()) {
                VariableBinding variable;
                lastVariable = variable = (VariableBinding)iterator.next();
                if (!variable.getOid().toString().startsWith(ifTable)) break;
                oids.add(new OIDParameterVariable(variable.getOid().toString(), IFTableRequest.variableToObject(variable.getVariable()), variable.getSyntax(), this.packet.getIpAddress()));
            }
            this.monitPdu.getVariableBindings().clear();
            if (lastVariable != null) {
                this.monitPdu.add(new VariableBinding(lastVariable.getOid()));
            }
            this.sendOidVariablePacket("IF_TABLE", this.packet.getDeviceId(), oids, null);
            if (variables.size() > oids.size()) break;
        }
    }

    public void initOIDSubtree(boolean send) throws IOException {
        try {
            Snmp snmpSession = this.getSnmpSession();
            try {
                List<OIDParameterVariable> ifIndexes = this.getIfIndexes(snmpSession, true);
                if (this.version == 0) {
                    this.monitPdu.setType(-95);
                } else {
                    this.monitPdu.setType(-91);
                    this.monitPdu.setMaxRepetitions(ifIndexes.size());
                }
                ArrayList<OIDParameterVariable> oids = new ArrayList<OIDParameterVariable>();
                oids.addAll(ifIndexes);
                String currentOid = ifDescr;
                block5: while (!currentOid.startsWith(ifAdminStatus)) {
                    this.monitPdu.getVariableBindings().clear();
                    this.monitPdu.add(new VariableBinding(new OID(currentOid)));
                    ResponseEvent event = snmpSession.send(this.monitPdu, this.monitTarget, null);
                    PDU response = event.getResponse();
                    if (response == null || response.getErrorStatus() != 0 || response.getType() == -88) break;
                    Vector variables = response.getVariableBindings();
                    for (VariableBinding variable : variables) {
                        currentOid = variable.getOid().toString();
                        if (currentOid.startsWith(ifAdminStatus)) continue block5;
                        oids.add(new OIDParameterVariable(currentOid, IFTableRequest.variableToObject(variable.getVariable()), variable.getSyntax(), this.packet.getIpAddress()));
                    }
                }
                if (send) {
                    this.sendOidVariablePacket("IF_TABLE", this.packet.getDeviceId(), oids, null);
                }
            }
            finally {
                this.closeSession(snmpSession);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

