/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.snmp.devices;

import com.dsoft.powerpro.monitoring.mserver.OIDParameterVariable;
import com.dsoft.powerpro.monitoring.mserver.reqeust.DeviceOIDParameterPacket;
import com.dsoft.powerpro.monitoring.mserver.response.InterfaceStatusPacket;
import com.dsoft.powerpro.monitorserver.MonitoringMessageProcessor;
import com.dsoft.powerpro.monitorserver.snmp.SNMPBaseMonitor;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.snmp4j.Snmp;

public class InterfaceStatusRequest
extends SNMPBaseMonitor {
    private static final Logger logger = Logger.getLogger(InterfaceStatusRequest.class.getName());

    public InterfaceStatusRequest() {
    }

    public InterfaceStatusRequest(DeviceOIDParameterPacket packet) {
        super(packet);
    }

    public InterfaceStatusRequest(int timeout, int retry) {
        super(timeout, retry);
    }

    public void getInterfaceStatus() {
        Snmp snmpSession = null;
        try {
            snmpSession = this.getSnmpSession();
            try {
                this.monitPdu.clear();
                this.readInterfaceIOStats(snmpSession, null);
            }
            finally {
                this.closeSession(snmpSession);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    protected void readInterfaceIOStats(Snmp snmpSession, int[] interfaceTypes) throws IOException {
        HashSet<String> variablesToGet = new HashSet<String>();
        variablesToGet.add("1.3.6.1.2.1.2.2.1.1");
        variablesToGet.add("1.3.6.1.2.1.2.2.1.2");
        variablesToGet.add("1.3.6.1.2.1.2.2.1.8");
        variablesToGet.add("1.3.6.1.2.1.2.2.1.3");
        variablesToGet.add("1.3.6.1.2.1.2.2.1.14");
        variablesToGet.add("1.3.6.1.2.1.2.2.1.20");
        variablesToGet.add("1.3.6.1.2.1.2.2.1.13");
        variablesToGet.add("1.3.6.1.2.1.2.2.1.19");
        HashMap<String, OIDParameterVariable> getResult = this.getOidTableVariables(snmpSession, variablesToGet, true);
        InterfaceStatusPacket monitorPacket = new InterfaceStatusPacket(this.packet.getDeviceId());
        if (getResult != null && !getResult.isEmpty()) {
            HashSet<String> indexToProcess = new HashSet<String>();
            for (String paramName : getResult.keySet()) {
                String index;
                if (!paramName.startsWith("1.3.6.1.2.1.2.2.1.1") || indexToProcess.contains(index = paramName.substring(paramName.lastIndexOf(".") + 1, paramName.length()))) continue;
                indexToProcess.add(index);
            }
            for (String index : indexToProcess) {
                String idx = "." + index;
                Integer intIndex = Integer.parseInt(index);
                monitorPacket.getIndexes().add(intIndex);
                HashMap descriptMap = (HashMap)monitorPacket.getStatusesMap().get("1.3.6.1.2.1.2.2.1.2");
                HashMap typeMap = (HashMap)monitorPacket.getStatusesMap().get("1.3.6.1.2.1.2.2.1.3");
                HashMap statusMap = (HashMap)monitorPacket.getStatusesMap().get("1.3.6.1.2.1.2.2.1.8");
                HashMap inDiscardsMap = (HashMap)monitorPacket.getStatusesMap().get("1.3.6.1.2.1.2.2.1.13");
                HashMap inErrrosMap = (HashMap)monitorPacket.getStatusesMap().get("1.3.6.1.2.1.2.2.1.14");
                HashMap outDiscardsMap = (HashMap)monitorPacket.getStatusesMap().get("1.3.6.1.2.1.2.2.1.19");
                HashMap outErrrorsMap = (HashMap)monitorPacket.getStatusesMap().get("1.3.6.1.2.1.2.2.1.20");
                OIDParameterVariable parVar = getResult.get("1.3.6.1.2.1.2.2.1.2" + idx);
                if (parVar != null) {
                    descriptMap.put(intIndex, parVar.getOidVariable());
                }
                if ((parVar = getResult.get("1.3.6.1.2.1.2.2.1.3" + idx)) != null) {
                    typeMap.put(intIndex, parVar.getOidVariable());
                }
                if ((parVar = getResult.get("1.3.6.1.2.1.2.2.1.8" + idx)) != null) {
                    statusMap.put(intIndex, parVar.getOidVariable());
                }
                if ((parVar = getResult.get("1.3.6.1.2.1.2.2.1.13" + idx)) != null) {
                    inDiscardsMap.put(intIndex, parVar.getOidVariable());
                }
                if ((parVar = getResult.get("1.3.6.1.2.1.2.2.1.14" + idx)) != null) {
                    inErrrosMap.put(intIndex, parVar.getOidVariable());
                }
                if ((parVar = getResult.get("1.3.6.1.2.1.2.2.1.19" + idx)) != null) {
                    outDiscardsMap.put(intIndex, parVar.getOidVariable());
                }
                if ((parVar = getResult.get("1.3.6.1.2.1.2.2.1.20" + idx)) == null) continue;
                outErrrorsMap.put(intIndex, parVar.getOidVariable());
            }
        }
        this.sendInterfaceStatusResponsePacket(this.packet.getRequestMarker(), this.packet.getDeviceId(), monitorPacket);
    }

    public void sendInterfaceStatusResponsePacket(String requestMarker, Integer deviceId, InterfaceStatusPacket monitorPacket) {
        monitorPacket.setPacketMarker(requestMarker);
        monitorPacket.setDeviceId(deviceId);
        monitorPacket.setQueueId(this.packet.getQueueId());
        MonitoringMessageProcessor.getInstance().sendInfoPacket((Serializable)monitorPacket, this.packet.getQueueId() != null);
    }
}

