/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.util;

import java.net.Inet6Address;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InterfaceUtils {
    private static final Logger LOGGER = Logger.getLogger(InterfaceUtils.class.getName());
    private static InterfaceUtils utils;

    public static InterfaceUtils getInstance() {
        if (utils == null) {
            utils = new InterfaceUtils();
        }
        return utils;
    }

    public static HashMap<String, ArrayList<InterfaceAddress>> scanInterfaces() throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        HashMap<String, ArrayList<InterfaceAddress>> result = new HashMap<String, ArrayList<InterfaceAddress>>();
        while (interfaces.hasMoreElements()) {
            NetworkInterface iface = interfaces.nextElement();
            LOGGER.log(Level.FINE, "Interface: " + iface.getName());
            ArrayList<InterfaceAddress> addressList = new ArrayList<InterfaceAddress>();
            result.put(iface.getName(), addressList);
            List<InterfaceAddress> ifaceList = iface.getInterfaceAddresses();
            for (InterfaceAddress ifaceAddress : ifaceList) {
                if (ifaceAddress.getAddress() instanceof Inet6Address) continue;
                addressList.add(ifaceAddress);
                StringBuilder log = new StringBuilder(String.valueOf(ifaceAddress.getAddress().getHostAddress()) + "/" + ifaceAddress.getNetworkPrefixLength());
                if (ifaceAddress.getBroadcast() != null) {
                    log.append(" " + ifaceAddress.getBroadcast().getHostAddress());
                }
                LOGGER.log(Level.FINE, log.toString());
            }
        }
        return result;
    }

    private InterfaceUtils() {
    }
}

