/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.monitorserver.util;

import com.dsoft.powerpro.monitorserver.util.BatchException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class LinuxRuntime {
    private boolean runAsRoot = false;
    private static final String SUDO = "sudo ";
    private ThreadLocal<HashMap<String, Process>> activeIpProcess = new ThreadLocal<HashMap<String, Process>>(){

        @Override
        protected HashMap<String, Process> initialValue() {
            return new HashMap<String, Process>();
        }
    };

    public LinuxRuntime() {
        if (System.getProperty("user.name").equals("root")) {
            this.runAsRoot = true;
        }
    }

    private String checkForSudo(String commandLine) {
        if (!this.runAsRoot) {
            commandLine = SUDO + commandLine;
        }
        return commandLine;
    }

    public void closeBatch(String commandLine) throws IOException {
        Process process = this.activeIpProcess.get().remove(commandLine);
        if (process != null) {
            process.getOutputStream().close();
            ArrayList<String> errorLines = this.readStream(process.getErrorStream());
            try {
                Iterator<String> iterator = errorLines.iterator();
                if (iterator.hasNext()) {
                    String line = iterator.next();
                    throw new IOException(line);
                }
            }
            finally {
                process.getInputStream().close();
            }
        }
    }

    public ArrayList<String> executeCommand(String commandLine) throws IOException {
        return this.executeCommand(commandLine, null);
    }

    public ArrayList<String> executeCommand(String commandLine, String options) throws IOException {
        commandLine = this.checkForSudo(commandLine);
        Process p = Runtime.getRuntime().exec(commandLine);
        OutputStream os = p.getOutputStream();
        try {
            if (options != null) {
                os.write(options.getBytes());
            }
        }
        finally {
            os.close();
        }
        ArrayList<String> errorLines = this.readStream(p.getErrorStream());
        try {
            Iterator<String> iterator = errorLines.iterator();
            if (iterator.hasNext()) {
                String line = iterator.next();
                throw new IOException(line);
            }
        }
        catch (IOException ex) {
            p.getInputStream().close();
            throw ex;
        }
        return this.readStream(p.getInputStream());
    }

    private ArrayList<String> readStream(InputStream inputStream) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader input = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            while ((line = input.readLine()) != null) {
                result.add(line);
            }
        }
        finally {
            input.close();
        }
        return result;
    }

    public void runBatchCommand(String batchCommand, String command) throws IOException {
        Process batchProcess = this.activeIpProcess.get().get(batchCommand);
        if (batchProcess != null) {
            OutputStream os = batchProcess.getOutputStream();
            os.write(command.getBytes());
            os.write(System.getProperty("line.separator").getBytes());
        }
    }

    public void startBatch(String commandLine) throws BatchException, IOException {
        String sudoCommandLine = this.checkForSudo(commandLine);
        if (this.activeIpProcess.get().containsKey(commandLine)) {
            throw new BatchException();
        }
        this.activeIpProcess.get().put(commandLine, Runtime.getRuntime().exec(sudoCommandLine));
    }
}

