/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.syslog.server;

import com.dsoft.powerpro.syslog.server.MessagePacket;
import java.util.HashMap;

public class SyslogMessageParser {
    public static final String MSG_IDENTIFIER = "LEASE: ";
    public static final String SHUTDOWN_MESSAGE = "SHUTDOWN SERVER";

    public static HashMap<String, Object> parseMessage(MessagePacket messagePacket) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        String message = messagePacket.getMessage();
        if (message == null || !message.startsWith(MSG_IDENTIFIER)) {
            return null;
        }
        propertyMap.put("PACKET_TIMESTAMP", messagePacket.getTimestamp());
        message = message.replaceFirst(MSG_IDENTIFIER, "");
        propertyMap.putAll(SyslogMessageParser.parseMessage(message));
        return propertyMap;
    }

    public static HashMap<String, Object> parseMessage(String message) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        String[] properties = message.split(" ");
        String lastProperty = null;
        int i = 0;
        while (i < properties.length - 1) {
            if (i == 0) {
                propertyMap.put("DEVICE_TYPE", properties[i]);
            } else if (properties[i].endsWith(":")) {
                lastProperty = properties[i];
                propertyMap.put(properties[i], properties[++i].trim());
            } else {
                propertyMap.put(lastProperty, propertyMap.get(lastProperty) + " " + properties[i].trim());
            }
            ++i;
        }
        return propertyMap;
    }
}

