/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.syslog.server;

import com.dsoft.powerpro.agent.BaseServerProperties;
import com.dsoft.powerpro.syslog.server.MessagePacket;
import com.dsoft.powerpro.syslog.server.SysLogPacketListener;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.picocontainer.annotations.Inject;

public class SyslogPacketReceiver
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(SyslogPacketReceiver.class.getName());
    private static final int BUFFER_SIZE = 4096;
    private DatagramPacket packet;
    private DatagramSocket socket;
    private boolean active = true;
    private static final int PACKET_PRI_ID = 30;
    private static final int PACKET_PRI_ID1 = 166;
    private BaseServerProperties properties;
    private static final DateFormat logDateFormat = new SimpleDateFormat("MMM d HH:");
    private Thread receiverThread;
    private ArrayList<SysLogPacketListener> listenerList = new ArrayList();

    public void addListener(SysLogPacketListener listener) {
        this.listenerList.add(listener);
    }

    @Override
    public void run() {
        block16: {
            try {
                try {
                    LOGGER.info("Starting syslog server listener");
                    byte[] logBuffer = new byte[4096];
                    String defaultPRIString = "30";
                    String defaultPRI1String = "166";
                    this.packet = new DatagramPacket(logBuffer, logBuffer.length);
                    this.socket = new DatagramSocket(this.properties.getSyslogPort());
                    while (this.active) {
                        try {
                            String receivedPacketPRI;
                            this.socket.receive(this.packet);
                            String packetData = new String(logBuffer, 0, this.packet.getLength(), "utf-8");
                            if (packetData.contains("\n")) {
                                packetData = packetData.substring(0, packetData.indexOf(10));
                            }
                            if (!(receivedPacketPRI = packetData.substring(1, packetData.indexOf(">"))).equals(defaultPRI1String) && !receivedPacketPRI.equals(defaultPRIString)) continue;
                            if (packetData.indexOf("LEASE: ") >= 0) {
                                String packetDate = packetData.substring(packetData.indexOf(">") + 1);
                                Calendar c = Calendar.getInstance();
                                int year = c.get(1);
                                try {
                                    c.setTime(logDateFormat.parse(packetDate));
                                    c.set(1, year);
                                }
                                catch (ParseException e) {
                                    LOGGER.log(Level.WARNING, String.format("Invalid date from syslog server(%1$s)", packetDate), e);
                                    continue;
                                }
                                packetData = packetData.substring(packetData.indexOf("LEASE: "));
                                MessagePacket packet = new MessagePacket(packetData, c.getTimeInMillis());
                                for (SysLogPacketListener listener : this.listenerList) {
                                    listener.processPacket(packet);
                                }
                                continue;
                            }
                            if (packetData.indexOf("SHUTDOWN SERVER") < 0) continue;
                            this.stopListen();
                            break;
                        }
                        catch (Exception ex) {
                            if (!this.active) continue;
                            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                    if (this.socket != null && !this.socket.isClosed()) {
                        this.socket.close();
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (this.socket != null && !this.socket.isClosed()) {
                    this.socket.close();
                }
                throw throwable;
            }
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
        System.exit(0);
    }

    @Inject
    public void setServerProperties(BaseServerProperties properties) {
        this.properties = properties;
    }

    @Inject
    public void setThreadGroup(ThreadGroup threadGroup) {
        this.receiverThread = new Thread(threadGroup, this, "Syslog listener thread");
        this.receiverThread.setDaemon(false);
    }

    @PostConstruct
    public void start() {
        this.receiverThread.start();
    }

    @PreDestroy
    public void stopListen() {
        this.active = false;
        if (this.socket != null) {
            this.socket.close();
        }
    }
}

