SET SQL DIALECT 3;
CREATE DATABASE 'localhost/3050:jboss' USER 'SYSDBA' PASSWORD 'masterkey' PAGE_SIZE 16384 DEFAULT CHARACTER SET UTF8;

CONNECT DATABASE 'localhost/3050:jboss' USER 'SYSDBA' PASSWORD 'masterkey';

CREATE TABLE JMS_MESSAGES 
(
  MESSAGEID                NUMERIC( 18, 0) NOT NULL,
  DESTINATION              VARCHAR(   180) NOT NULL,
  TXID                     NUMERIC( 18, 0),
  TXOP                        CHAR(     1),
  MESSAGEBLOB                 BLOB SUB_TYPE 0 SEGMENT SIZE 80
);
CREATE TABLE JMS_ROLES 
(
  ROLEID              VARCHAR(    32) NOT NULL,
  USERID              VARCHAR(    32) NOT NULL
);
CREATE TABLE JMS_SUBSCRIPTIONS 
(
  CLIENTID              VARCHAR(   100) NOT NULL,
  SUBNAME               VARCHAR(   100) NOT NULL,
  TOPIC                 VARCHAR(   255) NOT NULL,
  SELECTOR              VARCHAR(   255)
);
CREATE TABLE JMS_TRANSACTIONS 
(
  TXID              NUMERIC( 18, 0) NOT NULL
);
CREATE TABLE JMS_USERS 
(
  USERID                VARCHAR(    32) NOT NULL,
  PASSWD                VARCHAR(    32) NOT NULL,
  CLIENTID              VARCHAR(   128)
);
CREATE TABLE TIMERS 
(
  TIMERID                    VARCHAR(    80) NOT NULL,
  TARGETID                   VARCHAR(    80) NOT NULL,
  INITIALDATE              TIMESTAMP         NOT NULL,
  TIMERINTERVAL              NUMERIC( 18, 0),
  INSTANCEPK                    BLOB SUB_TYPE 0 SEGMENT SIZE 80,
  INFO                          BLOB SUB_TYPE 0 SEGMENT SIZE 80
);
/*******************************************************************************
 * Indices
 * -------
 * Extracted at 6.1.2012 г. 14:18:51
 ******************************************************************************/

CREATE ASC INDEX JMS_MESSAGES_DESTINATION ON JMS_MESSAGES (DESTINATION);
CREATE ASC INDEX JMS_MESSAGES_TXOP_TXID ON JMS_MESSAGES (TXOP, TXID);
/*******************************************************************************
 * Primary Key Constraints
 * -----------------------
 * Extracted at 6.1.2012 г. 14:18:51
 ******************************************************************************/

ALTER TABLE JMS_MESSAGES ADD PRIMARY KEY
  (MESSAGEID, DESTINATION);

ALTER TABLE JMS_ROLES ADD PRIMARY KEY
  (USERID, ROLEID);

ALTER TABLE JMS_SUBSCRIPTIONS ADD PRIMARY KEY
  (CLIENTID, SUBNAME);

ALTER TABLE JMS_TRANSACTIONS ADD PRIMARY KEY
  (TXID);

ALTER TABLE JMS_USERS ADD PRIMARY KEY
  (USERID);

ALTER TABLE TIMERS ADD CONSTRAINT TIMERS_PK PRIMARY KEY
  (TIMERID, TARGETID);

                                                              
commit;
