SET SQL DIALECT 3;
CREATE DATABASE 'localhost/3050:logger' USER 'SYSDBA' PASSWORD 'masterkey' PAGE_SIZE 16384 DEFAULT CHARACTER SET UTF8;

CONNECT DATABASE 'localhost/3050:logger' USER 'SYSDBA' PASSWORD 'masterkey';

CREATE TABLE LOGGER_FILTER 
(
  ID                                 INTEGER         NOT NULL,
  LOGGER_NAME                        VARCHAR(  1024),
  INCLUDE_JDBC_APPENDER              INTEGER,
  ADDITIVITY_FLAG                    INTEGER,
  LOGGER_LEVEL                       INTEGER
);
CREATE TABLE LOGGER_LOGGERS 
(
  ID                     INTEGER         NOT NULL,
  PARENTID               INTEGER,
  FULL_NAME              VARCHAR(   150)
);
CREATE TABLE LOGGER_MESSAGE 
(
  ID                                NUMERIC( 18, 0) NOT NULL,
  ACCOUNT                           INTEGER,
  MESSAGE_LEVEL                     INTEGER,
  LOGGER_NAME                       VARCHAR(  1024),
  FULL_NAME                         VARCHAR(   150),
  GENERATE_TIME                     NUMERIC( 18, 0),
  MESSAGE_STRING                    VARCHAR(  2048),
  IS_EXCEPTION_MESSAGE              INTEGER,
  BIGMESSAGE                           BLOB SUB_TYPE 0 SEGMENT SIZE 16,
  STACK_TRACKE                         BLOB SUB_TYPE 0 SEGMENT SIZE 1,
  LOGGERID                          INTEGER,
  TRANSACTIONID                     VARCHAR(   128)
);
/*******************************************************************************
 * Indices
 * -------
 * Extracted at 6.1.2012 г. 14:20:22
 ******************************************************************************/

CREATE ASC INDEX IDX_LOGGER_LOGGERS ON LOGGER_LOGGERS (FULL_NAME, ID);
CREATE ASC INDEX IDX_LOGGER_MESSAGE_001 ON LOGGER_MESSAGE (FULL_NAME, ID);
CREATE ASC INDEX IDX_LOGGER_MESSAGE_002 ON LOGGER_MESSAGE (GENERATE_TIME, MESSAGE_LEVEL, LOGGERID, IS_EXCEPTION_MESSAGE, ID);
CREATE ASC INDEX IDX_LOGGER_MESSAGE_004 ON LOGGER_MESSAGE (LOGGERID, GENERATE_TIME, ID);
CREATE ASC INDEX IDX_LOGGER_MESSAGE_005 ON LOGGER_MESSAGE (MESSAGE_LEVEL, LOGGERID, ID, GENERATE_TIME);
CREATE ASC INDEX IDX_LOGGER_MESSAGE_006 ON LOGGER_MESSAGE (MESSAGE_LEVEL, LOGGERID, GENERATE_TIME, ID);
/*******************************************************************************
 * Primary Key Constraints
 * -----------------------
 * Extracted at 6.1.2012 г. 14:20:22
 ******************************************************************************/

ALTER TABLE LOGGER_FILTER ADD CONSTRAINT PK_LOGGER_FILTER PRIMARY KEY
  (ID);

ALTER TABLE LOGGER_LOGGERS ADD CONSTRAINT PK_LOGGER_LOGGERS PRIMARY KEY
  (ID);

ALTER TABLE LOGGER_MESSAGE ADD CONSTRAINT PK_LOGGER_MESSAGE PRIMARY KEY
  (ID);

/*******************************************************************************
 * Foreign Key Constraints
 * -----------------------
 * Extracted at 6.1.2012 г. 14:20:22
 ******************************************************************************/

ALTER TABLE LOGGER_MESSAGE ADD CONSTRAINT FK_LOGGER_MESSAGE_001 
  FOREIGN KEY (LOGGERID) REFERENCES LOGGER_LOGGERS
  (ID);

commit;
