create database counters;

grant all privileges on counters.* to server@"localhost";

flush privileges;

use counters;

CREATE TABLE CM_DAILY_COUNTERS (
  DEVICEID          Integer(11) NOT NULL,
  DIRECTION         Integer(11) NOT NULL,
  COUNTER_DAY       BigInt NOT NULL,
  DAY_START_COUNTER BigInt,
  DAY_END_COUNTER   BigInt
) ;
CREATE TABLE CM_PERIOD_COUNTERS (
  DEVICEID      Integer(11) NOT NULL,
  DIRECTION     Integer(11) NOT NULL,
  PERIOD_START  BigInt NOT NULL,
  PERIOD_END    BigInt NOT NULL,
  START_COUNTER BigInt,
  END_COUNTER   BigInt
) ;
CREATE TABLE CM_TRAFFIC_ACCOUNTING (
  DEVICEID            Integer(11) NOT NULL,
  DIRECTION           Integer(11) NOT NULL,
  COUNTER             BigInt,
  MARKER              BigInt,
  LAST_MARKER_COUNTER BigInt,
  TIME_STAMP          BigInt,
  LAST_REPORT_TRAFFIC BigInt
) ;
CREATE TABLE LAN_COUNTERS (
  DEVICEID            Integer(11) NOT NULL,
  FLOWID              Integer(11) NOT NULL,
  DIRECTION           Integer(11) NOT NULL,
  COUNTER             BigInt,
  MARKER              BigInt,
  LAST_MARKER_COUNTER BigInt,
  TIME_STAMP          BigInt,
  LAST_REPORT_TRAFFIC BigInt
) ;
CREATE TABLE LAN_DAILY_COUNTERS (
  DEVICEID          Integer(11) NOT NULL,
  FLOWID            Integer(11) NOT NULL,
  DIRECTION         Integer(11) NOT NULL,
  COUNTER_DAY       BigInt NOT NULL,
  DAY_START_COUNTER BigInt,
  DAY_END_COUNTER   BigInt
) ;
CREATE TABLE LAN_PERIOD_COUNTERS (
  DEVICEID      Integer(11) NOT NULL,
  FLOWID        Integer(11) NOT NULL,
  DIRECTION     Integer(11) NOT NULL,
  PERIOD_START  BigInt NOT NULL,
  PERIOD_END    BigInt NOT NULL,
  START_COUNTER BigInt,
  END_COUNTER   BigInt
) ;
ALTER TABLE CM_DAILY_COUNTERS ADD PRIMARY KEY
    (DEVICEID, DIRECTION, COUNTER_DAY);

ALTER TABLE CM_PERIOD_COUNTERS ADD PRIMARY KEY
    (DEVICEID, DIRECTION, PERIOD_START);

ALTER TABLE CM_TRAFFIC_ACCOUNTING ADD PRIMARY KEY
    (DEVICEID, DIRECTION);

ALTER TABLE LAN_COUNTERS ADD PRIMARY KEY
    (DEVICEID, FLOWID, DIRECTION);

ALTER TABLE LAN_DAILY_COUNTERS ADD PRIMARY KEY
    (DEVICEID, FLOWID, DIRECTION, COUNTER_DAY);

ALTER TABLE LAN_PERIOD_COUNTERS ADD PRIMARY KEY
    (DEVICEID, FLOWID, DIRECTION, PERIOD_START);

delimiter /

CREATE PROCEDURE P_UPDATE_DAY_LAN_COUNTERS(DEVID Integer, FLID Integer, DIR Integer, CNT_DAY BigInt, CNT BigInt)
  NO SQL
begin
  declare prevDay BigInt;
  declare cnt1 integer;

  select count(*)
  from LAN_DAILY_COUNTERS
  where DEVICEID = DEVID and FLOWID = FLID and DIRECTION = DIR and COUNTER_DAY = CNT_DAY into cnt1;

  if cnt1 = 0 then
    select max(COUNTER_DAY) from LAN_DAILY_COUNTERS
    where DEVICEID = DEVID and FLOWID = FLID and DIRECTION = DIR into prevDay;

    if (prevDay is not null) then
      update LAN_DAILY_COUNTERS
      set DAY_END_COUNTER = cnt
      where COUNTER_DAY = prevDay and DEVICEID = DEVID and FLOWID = FLID and DIRECTION = DIR;
    end if;

    insert into LAN_DAILY_COUNTERS(DEVICEID, FLOWID, DIRECTION, COUNTER_DAY, DAY_START_COUNTER, DAY_END_COUNTER)
    VALUES (DEVID, FLID, DIR, cnt_day, cnt, cnt);
  else
    update LAN_DAILY_COUNTERS
    set DAY_END_COUNTER = cnt
    where COUNTER_DAY = cnt_day and DEVICEID = DEVID and FLOWID = FLID and DIRECTION = DIR;
  end if;
end
/
CREATE PROCEDURE P_UPDATE_DAY_MODEM_COUNTERS(DEVID Integer, DIR Integer, CNT_DAY BigInt, CNT BigInt)
  NO SQL
begin
  declare prevDay BigInt;
  declare cnt1 integer;

  select count(*)
  from CM_DAILY_COUNTERS
  where DEVICEID = DEVID and DIRECTION = DIR and COUNTER_DAY = CNT_DAY into cnt1;

  if cnt1 = 0 then
    select max(COUNTER_DAY) from CM_DAILY_COUNTERS
    where DEVICEID = DEVID and DIRECTION = DIR into prevDay;

    if (prevDay is not null) then
      update CM_DAILY_COUNTERS
      set DAY_END_COUNTER = CNT
      where COUNTER_DAY = prevDay and DEVICEID = DEVID and DIRECTION = DIR;
    end if;

    insert into CM_DAILY_COUNTERS(DEVICEID, DIRECTION, COUNTER_DAY, DAY_START_COUNTER, DAY_END_COUNTER)
    VALUES (DEVID, DIR, CNT_DAY, CNT, CNT);
  else
    update CM_DAILY_COUNTERS
    set DAY_END_COUNTER = CNT
    where COUNTER_DAY = CNT_DAY and DEVICEID = DEVID and DIRECTION = DIR;
  end if;
end
/
CREATE PROCEDURE P_UPDATE_PERIOD_LAN_COUNTERS(DEVID Integer, PERIOD_START BigInt, PERIOD_END BigInt)
  NO SQL
begin
  insert into LAN_PERIOD_COUNTERS(DEVICEID, DIRECTION, FLOWID, PERIOD_START, PERIOD_END, START_COUNTER, END_COUNTER)
  select max(DEVICEID), DIRECTION, FLOWID, min(COUNTER_DAY), max(COUNTER_DAY), min(DAY_START_COUNTER), max(DAY_START_COUNTER)
  from LAN_DAILY_COUNTERS
  where DEVICEID = DEVID
  and COUNTER_DAY >= PERIOD_START and COUNTER_DAY <= PERIOD_END
  group by DIRECTION, FLOWID;

  delete from  LAN_DAILY_COUNTERS  where DEVICEID = DEVID and COUNTER_DAY < PERIOD_START;
end
/
CREATE PROCEDURE P_UPDATE_PERIOD_MODEM_COUNTERS(DEV Integer, PERIOD_START BigInt, PERIOD_END BigInt)
  NO SQL
begin
  insert into CM_PERIOD_COUNTERS(DEVICEID, DIRECTION, PERIOD_START, PERIOD_END, START_COUNTER, END_COUNTER)
  select max(DEVICEID), DIRECTION, min(COUNTER_DAY), max(COUNTER_DAY), min(DAY_START_COUNTER), max(DAY_START_COUNTER)
  from CM_DAILY_COUNTERS
  where DEVICEID = DEVID
  and COUNTER_DAY >= PERIOD_START and COUNTER_DAY <= PERIOD_END
  group by DIRECTION;

  delete from CM_DAILY_COUNTERS where DEVICEID = DEVID and COUNTER_DAY < PERIOD_START;
end
/
delimiter ;

