SET SQL DIALECT 3;
CREATE DATABASE 'localhost/3050:streamer' USER 'SYSDBA' PASSWORD 'masterkey' PAGE_SIZE 16384 DEFAULT CHARACTER SET UTF8;

CONNECT DATABASE 'localhost/3050:streamer' USER 'SYSDBA' PASSWORD 'masterkey';

commit;
/* "PUBLIC" is a system role, no CREATE ROLE statement. */
CREATE GENERATOR GEN_IP_STREAMS_DATA_ID;
CREATE GENERATOR GEN_IP_STREAMS_FILES_ID;
CREATE GENERATOR GEN_IP_STREAMS_ID;
CREATE TABLE IP_STREAMS 
(
  ID                       INTEGER         NOT NULL,
  STREAM_NAME              VARCHAR(    50) NOT NULL,
  HOST                     VARCHAR(   200),
  PORT                     INTEGER,
  LOOP_STREAM              INTEGER,
  STATUS                   INTEGER,
  DESCRIPTION              VARCHAR(   250),
  SIM_STREAM               INTEGER
);
CREATE TABLE IP_STREAMS_DATA 
(
  ID                      INTEGER         NOT NULL,
  STREAM_ID               INTEGER         NOT NULL,
  FILE_NAME               VARCHAR(    50) NOT NULL,
  FILE_BPS                 BIGINT         NOT NULL,
  FILE_ID                  BIGINT,
  VIEW_NAME               VARCHAR(   150),
  FILE_BYTES               BIGINT
);
CREATE TABLE IP_STREAMS_FILES 
(
  ID                           BIGINT         NOT NULL,
  FILE_NAME                   VARCHAR(    50) NOT NULL,
  DESCRIPTION                 VARCHAR(   200) NOT NULL,
  NAME_ON_SERVER              VARCHAR(   150) NOT NULL,
  FILE_BYTES                   BIGINT
);
ALTER TABLE IP_STREAMS ADD CONSTRAINT PK_IP_STREAMS PRIMARY KEY
  (ID);

ALTER TABLE IP_STREAMS_DATA ADD CONSTRAINT PK_IP_STREAMS_DATA PRIMARY KEY
  (ID);

ALTER TABLE IP_STREAMS_FILES ADD CONSTRAINT PK_IP_STREAMS_FILES PRIMARY KEY
  (ID);

ALTER TABLE IP_STREAMS_DATA ADD CONSTRAINT FK_IP_STREAMS_DA_IP_STREAMS 
  FOREIGN KEY (STREAM_ID) REFERENCES IP_STREAMS
  (ID) 
;

ALTER TABLE IP_STREAMS_DATA ADD CONSTRAINT FK_IP_STREAMS__IP_STREAMS_ 
  FOREIGN KEY (FILE_ID) REFERENCES IP_STREAMS_FILES
  (ID) 
;

SET TERM ^^ ;
CREATE TRIGGER IP_STREAMS_DATA_GEN_ID FOR IP_STREAMS_DATA ACTIVE BEFORE INSERT POSITION 0 AS
begin
  if ((new.id is null) or (new.id = 0)) then
  begin
    new.id = gen_id( GEN_IP_STREAMS_DATA_ID, 1 );
  end
end ^^
SET TERM ; ^^
SET TERM ^^ ;
CREATE TRIGGER IP_STREAMS_FILES_GEN_ID FOR IP_STREAMS_FILES ACTIVE BEFORE INSERT POSITION 0 AS
begin
  if ((new.id is null) or (new.id = 0)) then
  begin
    new.id = gen_id( GEN_IP_STREAMS_FILES_ID, 1 );
  end
end ^^
SET TERM ; ^^
SET TERM ^^ ;
CREATE TRIGGER IP_STREAMS_GEN_ID FOR IP_STREAMS ACTIVE BEFORE INSERT POSITION 0 AS
begin
  if ((new.id is null) or (new.id = 0)) then
  begin
    new.id = gen_id( GEN_IP_STREAMS_ID, 1 );
  end
end ^^
SET TERM ; ^^
