#!/bin/bash

if [ -f /etc/sysconfig/powerpro ]; then 
  . /etc/sysconfig/powerpro
fi

cd /opt/powerpro

IP_ADDR=${JBOSS_BIND_ADDRESS:-"127.0.0.1"}

JAR_FILE=monitoringServer.jar
APP_OPTIONS="--syslog-port=5140 -db /opt/powerpro/monitor --agent-id=ariel1 -s $IP_ADDR"
JAVA_OPTS="-Xmx256m"
JAVA_PATH=${JAVAPATH:-"/opt/jdk1.6.0_22/bin"}

JAVA_OPTS="$JAVA_OPTS -XX:+UseParNewGC -XX:+CMSParallelRemarkEnabled -XX:+UseConcMarkSweepGC -XX:SurvivorRatio=16 -XX:NewSize=128m"
#Enable JMX
#JAVA_OPTS="$JAVA_OPTS -Dcom.sun.management.jmxremote.port=9999 -Dcom.sun.management.jmxremote.authenticate=false -Dcom.sun.management.jmxremote.ssl=false"

# Enable remote Debug
#JAVA_OPTS="$JAVA_OPTS -Xrunjdwp:transport=dt_socket,address=8788,server=y,suspend=n"

JAVA_OPTS="$JAVA_OPTS -jar $JAR_FILE"

$JAVA_PATH/java $JAVA_OPTS $APP_OPTIONS 2>&1 &

